/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.parser;

import com.nosolojava.fsm.impl.model.basic.BasicStateMachineModel;
import com.nosolojava.fsm.impl.model.basic.datamodel.BasicBody;
import com.nosolojava.fsm.impl.model.basic.datamodel.BasicContent;
import com.nosolojava.fsm.impl.model.basic.datamodel.BasicData;
import com.nosolojava.fsm.impl.model.basic.datamodel.BasicParam;
import com.nosolojava.fsm.impl.model.basic.state.BasicDoneData;
import com.nosolojava.fsm.impl.model.basic.state.BasicHistoryState;
import com.nosolojava.fsm.impl.model.basic.state.BasicInitialState;
import com.nosolojava.fsm.impl.model.basic.state.BasicState;
import com.nosolojava.fsm.impl.model.basic.transition.BasicTransition;
import com.nosolojava.fsm.impl.runtime.executable.basic.BasicAssign;
import com.nosolojava.fsm.impl.runtime.executable.basic.BasicElif;
import com.nosolojava.fsm.impl.runtime.executable.basic.BasicElse;
import com.nosolojava.fsm.impl.runtime.executable.basic.BasicForEach;
import com.nosolojava.fsm.impl.runtime.executable.basic.BasicIf;
import com.nosolojava.fsm.impl.runtime.executable.basic.BasicLocalScript;
import com.nosolojava.fsm.impl.runtime.executable.basic.BasicRaise;
import com.nosolojava.fsm.impl.runtime.executable.basic.BasicRemoteScript;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic.BasicFinalize;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic.BasicInvoke;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic.BasicSend;
import com.nosolojava.fsm.model.StateMachineModel;
import com.nosolojava.fsm.model.config.exception.ConfigurationException;
import com.nosolojava.fsm.model.datamodel.Body;
import com.nosolojava.fsm.model.datamodel.Data;
import com.nosolojava.fsm.model.datamodel.Param;
import com.nosolojava.fsm.model.externalcomm.Invoke;
import com.nosolojava.fsm.model.state.HistoryTypes;
import com.nosolojava.fsm.model.state.InitialState;
import com.nosolojava.fsm.model.state.State;
import com.nosolojava.fsm.model.transition.Transition;
import com.nosolojava.fsm.parser.AssertCustomActionParser;
import com.nosolojava.fsm.parser.StateMachineParser;
import com.nosolojava.fsm.parser.XppActionParser;
import com.nosolojava.fsm.parser.exception.SCXMLParserException;
import com.nosolojava.fsm.runtime.executable.Elif;
import com.nosolojava.fsm.runtime.executable.Executable;
import com.nosolojava.fsm.runtime.executable.If;
import com.nosolojava.fsm.runtime.executable.Log;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XppStateMachineParser
implements StateMachineParser {
    public static final String SCXML = "scxml";
    public static final String INITIAL = "initial";
    public static final String STATE = "state";
    private static final String PARALLEL = "parallel";
    private static final String HISTORY = "history";
    private static final String FINAL = "final";
    public static final String TRANSITION = "transition";
    public static final String SEND = "send";
    public static final String INVOKE = "invoke";
    public static final String ID = "id";
    public static final String IDLOCATION = "idlocation";
    public static final String NAME = "name";
    public static final String ON_ENTRY = "onentry";
    public static final String ON_EXIT = "onexit";
    static final String TARGET = "target";
    static final String TARGETEXPR = "targetexpr";
    static final String EVENT = "event";
    static final String EVENTEXPR = "eventexpr";
    static final String GUARD_CONDITION = "cond";
    static final String TYPE = "type";
    static final String TYPEEXPR = "typeexpr";
    static final String INTERNAL = "internal";
    static final String RAISE = "raise";
    static final String IF_COND = "if";
    static final String ELSE_COND = "else";
    static final String ELIF_COND = "elif";
    static final String FOR_EACH = "foreach";
    static final String ASSIGN = "assign";
    static final String LOCATION = "location";
    static final String EXPRESSION = "expr";
    static final String DATAMODEL = "datamodel";
    static final String SRC = "src";
    static final String SRC_EXPRESSION = "srcexpr";
    static final String ARRAY = "array";
    static final String ITEM = "item";
    static final String INDEX = "index";
    static final String DELAY = "delay";
    static final String DELAYEXPR = "delayexpr";
    static final String NAMELIST = "namelist";
    static final String PARAM = "param";
    static final String EXPR = "expr";
    static final String CONTENT = "content";
    static final String SCRIPT = "script";
    static final String AUTO_FORWARD = "autoforward";
    static final String TRUE = "true";
    static final String FINALIZE = "finalize";
    static final String DONEDATA = "donedata";
    protected static final String LOG = "log";
    protected static final String LABEL = "label";
    public static final String CLASSPATH = "classpath";
    public static final String HTTP = "http";
    private final Map<String, XppActionParser> actionParsers = new ConcurrentHashMap<String, XppActionParser>();

    public XppStateMachineParser() throws ConfigurationException {
        this(null);
    }

    public XppStateMachineParser(List<XppActionParser> actionParsers) throws ConfigurationException {
        this.loadDefaultActionParsers();
        if (actionParsers != null) {
            for (XppActionParser actionParser : actionParsers) {
                String ns = actionParser.getNamespace();
                if (this.actionParsers.containsKey(ns)) {
                    throw new ConfigurationException("Action parser repeated for ns {0}", new Object[]{ns});
                }
                this.actionParsers.put(ns, actionParser);
            }
        }
    }

    private void loadDefaultActionParsers() {
        this.actionParsers.put("http://nosolojava.com/customActions/assert", new AssertCustomActionParser());
    }

    public boolean validURI(URI source) {
        boolean result = false;
        if (source != null) {
            if (this.isClasspathURI(source)) {
                result = true;
            } else {
                try {
                    new URL(source.toString());
                    result = true;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    protected boolean isClasspathURI(URI source) {
        return this.hasURIScheme(source, CLASSPATH);
    }

    protected boolean isHttpURI(URI source) {
        return this.hasURIScheme(source, HTTP);
    }

    protected boolean hasURIScheme(URI source, String scheme) {
        return source != null && source.getScheme().equals(scheme);
    }

    public StateMachineModel parseScxml(URI source) throws ConfigurationException, IOException, SCXMLParserException {
        if (source == null) {
            throw new SCXMLParserException("Error parsing SCXML, source is null");
        }
        InputStream is = null;
        if (this.isClasspathURI(source)) {
            String location = source.getSchemeSpecificPart();
            is = ClassLoader.getSystemClassLoader().getResourceAsStream(location);
        } else {
            try {
                URL url = new URL(source.toString());
                is = (InputStream)url.getContent();
            }
            catch (Exception e) {
                throw new SCXMLParserException(String.format("SCXML uri %s is not supported.", source), (Throwable)e);
            }
        }
        StateMachineModel model = null;
        try {
            XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setInput(is, null);
            model = this.parseXPP(parser, "");
        }
        catch (XmlPullParserException e) {
            throw new ConfigurationException("Error parsing scxml from classpath with xpp, uri: " + source, (Throwable)e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return model;
    }

    protected StateMachineModel createStateMachine(State rootState) {
        BasicStateMachineModel smm = new BasicStateMachineModel(rootState);
        return smm;
    }

    protected State createRootState() throws ConfigurationException {
        BasicState rootState = BasicState.createRootState();
        return rootState;
    }

    protected Executable createAssignByValue(String location, String value) {
        BasicAssign currentExec = BasicAssign.assignByValue(location, value);
        return currentExec;
    }

    protected Executable createAssignByExpression(String location, String expr) {
        BasicAssign currentExec = BasicAssign.assignByExpression(location, expr);
        return currentExec;
    }

    public StateMachineModel parseXPP(XmlPullParser xpp) throws XmlPullParserException, IOException, ConfigurationException {
        return this.parseXPP(xpp, null);
    }

    public StateMachineModel parseXPP(XmlPullParser xpp, String namespace) throws XmlPullParserException, IOException, ConfigurationException {
        xpp.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        StateMachineModel smm = null;
        State currentState = null;
        Transition currentTransition = null;
        Invoke invoke = null;
        while (xpp.getEventType() != 1) {
            String tagName = xpp.getName();
            if (xpp.getEventType() == 2) {
                List<Executable> executables;
                if (SCXML.equals(tagName)) {
                    smm = this.parseRootState(namespace, xpp);
                    currentState = smm.getRootState();
                } else if (INITIAL.equals(tagName)) {
                    this.parseInitialState(namespace, xpp, currentState);
                } else if (HISTORY.equals(tagName)) {
                    this.parseHistoryState(namespace, xpp, currentState);
                } else if (STATE.equals(tagName) || PARALLEL.equals(tagName) || FINAL.equals(tagName)) {
                    if ((currentState = this.parseState(namespace, xpp, currentState, tagName)).isFinal()) {
                        currentState = currentState.getParent();
                    }
                } else if (TRANSITION.equals(tagName)) {
                    currentTransition = this.parseTransition(namespace, xpp, currentState);
                    currentState.addTransition(currentTransition);
                    executables = this.parseExecutables(namespace, xpp);
                    currentTransition.addExecutables(executables);
                } else if (ON_ENTRY.equals(tagName)) {
                    executables = this.parseExecutables(namespace, xpp);
                    currentState.addOnEntryExecutables(executables);
                } else if (ON_EXIT.equals(tagName)) {
                    executables = this.parseExecutables(namespace, xpp);
                    currentState.addOnExitExecutables(executables);
                } else if (DATAMODEL.equals(tagName)) {
                    this.parseDatamodel(namespace, xpp, currentState);
                } else if (INVOKE.equals(tagName)) {
                    invoke = this.parseInvoke(namespace, xpp);
                    currentState.addInvoke(invoke);
                }
            } else if (xpp.getEventType() == 3) {
                if (STATE.equals(tagName) || PARALLEL.equals(tagName) || FINAL.equals(tagName)) {
                    currentState = currentState.getParent();
                }
                if (TRANSITION.equals(tagName)) {
                    currentTransition = null;
                }
            } else if (xpp.getEventType() == 4) {
                // empty if block
            }
            xpp.next();
        }
        return smm;
    }

    protected Executable parseLog(String namespace, XmlPullParser xpp) {
        Executable result = null;
        String label = xpp.getAttributeValue(namespace, LABEL);
        String expr = xpp.getAttributeValue(namespace, "expr");
        if (label == null) {
            label = this.getClass().getCanonicalName();
        }
        result = this.createLog(label, expr);
        return result;
    }

    protected Executable createLog(String label, String expr) {
        Log result = new Log(label, expr);
        return result;
    }

    private void parseDatamodel(String namespace, XmlPullParser xpp, State currentState) throws XmlPullParserException, IOException, ConfigurationException {
        String endTag = xpp.getName();
        while (!endTag.equals(xpp.getName()) || xpp.getEventType() != 3) {
            BasicData data;
            xpp.next();
            if (xpp.getEventType() != 2) continue;
            String id = xpp.getAttributeValue(namespace, ID);
            if (id == null) {
                throw new ConfigurationException("ID is mandatory for data element");
            }
            String src = xpp.getAttributeValue(namespace, SRC);
            if (src != null) {
                data = BasicData.createSrcData(id, new URL(src));
            } else {
                String expr = xpp.getAttributeValue(namespace, "expr");
                if (expr != null) {
                    data = BasicData.createExpressionData(id, expr);
                } else {
                    String content = xpp.nextText();
                    data = BasicData.createValueData(id, content);
                }
            }
            currentState.addData((Data)data);
        }
    }

    private Invoke parseInvoke(String ns, XmlPullParser xpp) throws XmlPullParserException, IOException, ConfigurationException {
        String endTag = xpp.getName();
        String id = xpp.getAttributeValue(ns, ID);
        String idLocation = xpp.getAttributeValue(ns, IDLOCATION);
        String srcString = xpp.getAttributeValue(ns, SRC);
        URI src = null;
        if (srcString != null) {
            try {
                src = new URI(srcString);
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
        String srcExpression = xpp.getAttributeValue(ns, SRC_EXPRESSION);
        String type = xpp.getAttributeValue(ns, TYPE);
        String typeExpression = xpp.getAttributeValue(ns, TYPEEXPR);
        String namelist = xpp.getAttributeValue(ns, NAMELIST);
        String autoForwardString = xpp.getAttributeValue(ns, AUTO_FORWARD);
        boolean autoForward = autoForwardString != null && TRUE.equals(autoForwardString);
        BasicFinalize finalize = null;
        String content = null;
        String contentExpr = null;
        HashSet<Param> params = new HashSet<Param>();
        while (!endTag.equals(xpp.getName()) || xpp.getEventType() != 3) {
            xpp.next();
            if (xpp.getEventType() != 2) continue;
            if (PARAM.equals(xpp.getName()) && xpp.getEventType() != 3) {
                String name = xpp.getAttributeValue(ns, NAME);
                String expr = xpp.getAttributeValue(ns, "expr");
                String location = xpp.getAttributeValue(ns, LOCATION);
                BasicParam param = new BasicParam(name, expr, location);
                params.add(param);
            }
            if (CONTENT.equals(xpp.getName()) && xpp.getEventType() != 3 && (contentExpr = xpp.getAttributeValue(ns, "expr")) == null) {
                xpp.next();
                content = xpp.getText();
            }
            if (!FINALIZE.equals(xpp.getName()) || xpp.getEventType() == 3) continue;
            List<Executable> executables = this.parseExecutables(ns, xpp);
            finalize = new BasicFinalize(executables);
        }
        Body body = this.extractBody(namelist, content, contentExpr, params);
        BasicInvoke result = new BasicInvoke(id, idLocation, src, srcExpression, type, typeExpression, autoForward, finalize, body);
        return result;
    }

    private List<Executable> parseExecutables(String scxmlNamespace, XmlPullParser xpp) throws XmlPullParserException, IOException, ConfigurationException {
        String endTag = xpp.getName();
        ArrayList<Executable> result = new ArrayList<Executable>();
        Executable currentExec = null;
        while (!endTag.equals(xpp.getName()) || xpp.getEventType() != 3) {
            xpp.next();
            if (xpp.getEventType() == 2) {
                currentExec = this.parseExecutable(scxmlNamespace, xpp);
                if (currentExec == null) continue;
                result.add(currentExec);
                continue;
            }
            if (xpp.getEventType() != 3) continue;
            currentExec = null;
        }
        return result;
    }

    private Executable parseExecutable(String scxmlNamespace, XmlPullParser xpp) throws XmlPullParserException, IOException, ConfigurationException {
        String tagName = xpp.getName();
        Object currentExec = null;
        if (RAISE.equals(tagName)) {
            String eventName = xpp.getAttributeValue(scxmlNamespace, EVENT);
            currentExec = new BasicRaise(eventName);
        } else if (SEND.equals(tagName)) {
            currentExec = this.parseSend(scxmlNamespace, xpp);
        } else if (IF_COND.equals(tagName)) {
            currentExec = this.parseIf(scxmlNamespace, xpp);
        } else if (ASSIGN.equals(tagName)) {
            currentExec = this.parseAssign(scxmlNamespace, xpp);
        } else if (FOR_EACH.equals(tagName)) {
            currentExec = this.parseForEach(scxmlNamespace, xpp);
        } else if (LOG.equals(tagName)) {
            currentExec = this.parseLog(scxmlNamespace, xpp);
        } else if (SCRIPT.equals(tagName)) {
            currentExec = this.parseScript(scxmlNamespace, xpp);
        } else {
            String ns = xpp.getNamespace();
            if (!this.actionParsers.containsKey(ns)) {
                throw new ConfigurationException("Can''t parse tag {0}, it should be a custom action. Try to register a custom action for namespace: {1}", new Object[]{tagName, ns});
            }
            XppActionParser parser = this.actionParsers.get(ns);
            currentExec = parser.parseAction(xpp);
        }
        return currentExec;
    }

    private Executable parseScript(String namespace, XmlPullParser xpp) throws ConfigurationException, XmlPullParserException, IOException {
        Object result = null;
        String urlExpr = xpp.getAttributeValue(namespace, SRC);
        String content = xpp.nextText();
        if (content == null) {
            content = "";
        }
        if (urlExpr != null && !"".equals(content.trim())) {
            throw new ConfigurationException("Script can't have src attribute and content");
        }
        result = urlExpr != null ? new BasicRemoteScript(urlExpr) : new BasicLocalScript(content);
        return result;
    }

    private Executable parseSend(String ns, XmlPullParser xpp) throws XmlPullParserException, IOException, ConfigurationException {
        URI target;
        String eventName = xpp.getAttributeValue(ns, EVENT);
        String eventexpr = xpp.getAttributeValue(ns, EVENTEXPR);
        String targetString = xpp.getAttributeValue(ns, TARGET);
        try {
            target = targetString != null ? new URI(targetString) : null;
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException((Throwable)e);
        }
        String targetexpr = xpp.getAttributeValue(ns, TARGETEXPR);
        String type = xpp.getAttributeValue(ns, TYPE);
        String typeexpr = xpp.getAttributeValue(ns, TYPEEXPR);
        String id = xpp.getAttributeValue(ns, ID);
        String idlocation = xpp.getAttributeValue(ns, IDLOCATION);
        String delayString = xpp.getAttributeValue(ns, DELAY);
        Long delay = delayString != null ? this.parseLong(delayString) : null;
        String delayexpr = xpp.getAttributeValue(ns, DELAYEXPR);
        String namelist = xpp.getAttributeValue(ns, NAMELIST);
        String content = null;
        String contentExpr = null;
        HashSet<Param> params = new HashSet<Param>();
        while (!SEND.equals(xpp.getName()) || xpp.getEventType() != 3) {
            xpp.next();
            if (PARAM.equals(xpp.getName()) && xpp.getEventType() != 3) {
                String name = xpp.getAttributeValue(ns, NAME);
                String expr = xpp.getAttributeValue(ns, "expr");
                String location = xpp.getAttributeValue(ns, LOCATION);
                BasicParam param = new BasicParam(name, expr, location);
                params.add(param);
            }
            if (!CONTENT.equals(xpp.getName()) || xpp.getEventType() == 3 || (contentExpr = xpp.getAttributeValue(ns, "expr")) != null) continue;
            xpp.next();
            content = xpp.getText();
        }
        Body body = this.extractBody(namelist, content, contentExpr, params);
        BasicSend result = new BasicSend(id, idlocation, eventName, eventexpr, type, typeexpr, target, targetexpr, delay, delayexpr, body);
        return result;
    }

    protected Body extractBody(String namelist, String content, String contentExpr, Set<Param> params) throws ConfigurationException {
        BasicBody body = null;
        if (content != null && contentExpr != null) {
            throw new ConfigurationException("Can't be both content children and content expression");
        }
        if (!(content == null && contentExpr == null || params == null || params.isEmpty())) {
            throw new ConfigurationException("Can't be both content and params");
        }
        body = content != null ? BasicBody.createContentBody(BasicContent.createSimpleContent(content)) : (contentExpr != null ? BasicBody.createContentBody(BasicContent.createContentExpression(contentExpr)) : BasicBody.createParamsBody(params, namelist));
        return body;
    }

    private Executable parseForEach(String scxmlNamespace, XmlPullParser xpp) throws XmlPullParserException, IOException, ConfigurationException {
        String array = xpp.getAttributeValue(scxmlNamespace, ARRAY);
        String item = xpp.getAttributeValue(scxmlNamespace, ITEM);
        String index = xpp.getAttributeValue(scxmlNamespace, INDEX);
        List<Executable> executables = this.parseExecutables(scxmlNamespace, xpp);
        BasicForEach result = new BasicForEach(array, item, index, executables);
        return result;
    }

    private Executable parseAssign(String scxmlNamespace, XmlPullParser xpp) throws XmlPullParserException, IOException {
        Executable currentExec;
        String location = xpp.getAttributeValue(scxmlNamespace, LOCATION);
        String expr = xpp.getAttributeValue(scxmlNamespace, "expr");
        if (expr != null) {
            currentExec = this.createAssignByExpression(location, expr);
        } else {
            String value = xpp.nextText();
            currentExec = this.createAssignByValue(location, value);
        }
        return currentExec;
    }

    private If parseIf(String scxmlNamespace, XmlPullParser xpp) throws XmlPullParserException, IOException, ConfigurationException {
        String ifcond = xpp.getAttributeValue(scxmlNamespace, GUARD_CONDITION);
        ArrayList<Elif> elifs = new ArrayList<Elif>();
        String elifcond = null;
        BasicElse elseOperation = null;
        ArrayList<Executable> ifExecutables = new ArrayList<Executable>();
        List<Executable> elifExecutables = new ArrayList<Executable>();
        ArrayList<Executable> elseExecutables = new ArrayList<Executable>();
        boolean foundElif = false;
        boolean foundElse = false;
        while (!xpp.getName().equals(IF_COND) || xpp.getEventType() != 3) {
            xpp.nextTag();
            String tagName = xpp.getName();
            if (xpp.getEventType() != 2) continue;
            if (ELIF_COND.equals(tagName)) {
                if (foundElif) {
                    elifExecutables = this.loadPreviousElif(scxmlNamespace, xpp, elifs, elifExecutables, elifcond);
                }
                elifcond = xpp.getAttributeValue(scxmlNamespace, GUARD_CONDITION);
                foundElif = true;
                continue;
            }
            if (ELSE_COND.equals(tagName)) {
                foundElse = true;
                continue;
            }
            Executable exec = this.parseExecutable(scxmlNamespace, xpp);
            if (!foundElif && !foundElse) {
                ifExecutables.add(exec);
                continue;
            }
            if (foundElif && !foundElse) {
                elifExecutables.add(exec);
                continue;
            }
            elseExecutables.add(exec);
        }
        if (foundElif) {
            elifExecutables = this.loadPreviousElif(scxmlNamespace, xpp, elifs, elifExecutables, elifcond);
        }
        if (foundElse) {
            elseOperation = new BasicElse(elseExecutables);
        }
        BasicIf result = new BasicIf(ifcond, elifs, elseOperation, ifExecutables);
        return result;
    }

    private List<Executable> loadPreviousElif(String scxmlNamespace, XmlPullParser xpp, List<Elif> elifs, List<Executable> elifExecutables, String elifcond) {
        BasicElif elif = new BasicElif(elifcond, elifExecutables);
        elifs.add(elif);
        elifExecutables = new ArrayList<Executable>();
        return elifExecutables;
    }

    private Transition parseTransition(String ns, XmlPullParser xpp, State currentState) {
        BasicTransition result = null;
        String targetState = xpp.getAttributeValue(ns, TARGET);
        String eventName = xpp.getAttributeValue(ns, EVENT);
        String guardCondition = xpp.getAttributeValue(ns, GUARD_CONDITION);
        String type = xpp.getAttributeValue(ns, TYPE);
        boolean internal = type != null && INTERNAL.equals(type);
        result = new BasicTransition(currentState.getName(), eventName, targetState, guardCondition, internal);
        return result;
    }

    private void parseInitialState(String ns, XmlPullParser xpp, State state) throws ConfigurationException, XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(ns, ID);
        this.goUntil(xpp, 2);
        if (!TRANSITION.equals(xpp.getName())) {
            this.tagNotExpectedError(xpp, TRANSITION, xpp.getName());
        }
        Transition initialTransition = this.parseTransition(ns, xpp, state);
        List<Executable> executables = this.parseExecutables(ns, xpp);
        if (executables.size() > 0) {
            initialTransition.addExecutables(executables);
        }
        BasicInitialState initial = new BasicInitialState(id, initialTransition);
        state.setInitialState((InitialState)initial);
    }

    private void parseHistoryState(String ns, XmlPullParser xpp, State state) throws ConfigurationException, XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(ns, ID);
        String historyTypeString = xpp.getAttributeValue(ns, TYPE);
        HistoryTypes historyType = historyTypeString == null || historyTypeString.equals("") ? HistoryTypes.SHALLOW : HistoryTypes.fromString((String)historyTypeString);
        this.goUntil(xpp, 2);
        if (!TRANSITION.equals(xpp.getName())) {
            this.tagNotExpectedError(xpp, TRANSITION, xpp.getName());
        }
        String targetState = xpp.getAttributeValue(ns, TARGET);
        new BasicHistoryState(state, id, historyType, targetState);
    }

    private void tagNotExpectedError(XmlPullParser scxmlParser, String expected, String found) throws ConfigurationException {
        throw new ConfigurationException("Tag {0} not expected. {1} expected. Line number: {2}", new Object[]{found, expected, scxmlParser.getLineNumber()});
    }

    private State parseState(String ns, XmlPullParser xpp, State parent, String tagName) throws XmlPullParserException, IOException, ConfigurationException {
        BasicState state;
        String id = xpp.getAttributeValue(ns, ID);
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        if (STATE.equals(tagName)) {
            state = BasicState.createBasicState(id, parent);
            String initialStateName = xpp.getAttributeValue(ns, INITIAL);
            if (initialStateName != null && !"".equals(initialStateName)) {
                state.setInitialStateName(initialStateName);
            }
        } else if (FINAL.equals(tagName)) {
            String content = null;
            String contentExpr = null;
            HashSet<Param> params = new HashSet<Param>();
            List<Executable> onEntryExec = null;
            List<Executable> onExitExec = null;
            while (!FINAL.equals(xpp.getName()) || xpp.getEventType() != 3) {
                xpp.next();
                if (xpp.getEventType() != 2) continue;
                if (PARAM.equals(xpp.getName()) && xpp.getEventType() != 3) {
                    String name = xpp.getAttributeValue(ns, NAME);
                    String expr = xpp.getAttributeValue(ns, "expr");
                    String location = xpp.getAttributeValue(ns, LOCATION);
                    BasicParam param = new BasicParam(name, expr, location);
                    params.add(param);
                }
                if (CONTENT.equals(xpp.getName()) && xpp.getEventType() != 3) {
                    contentExpr = xpp.getAttributeValue(ns, "expr");
                    if (contentExpr != null) continue;
                    xpp.next();
                    content = xpp.getText();
                    continue;
                }
                if (ON_ENTRY.equals(xpp.getName())) {
                    onEntryExec = this.parseExecutables(ns, xpp);
                    continue;
                }
                if (!ON_EXIT.equals(xpp.getName())) continue;
                onExitExec = this.parseExecutables(ns, xpp);
            }
            Body body = this.extractBody(null, content, contentExpr, params);
            BasicDoneData doneData = new BasicDoneData(body);
            state = BasicState.createFinalState(id, parent, doneData);
            if (onEntryExec != null) {
                state.addOnEntryExecutables(onEntryExec);
            }
            if (onExitExec != null) {
                state.addOnExitExecutables(onExitExec);
            }
        } else {
            state = BasicState.createParallelState(id, parent);
        }
        return state;
    }

    private void goUntil(XmlPullParser scxmlParser, int startTag) throws XmlPullParserException, IOException {
        int next = scxmlParser.next();
        while (next != 1 && next != startTag) {
            next = scxmlParser.next();
        }
    }

    private StateMachineModel parseRootState(String namespace, XmlPullParser scxmlParser) throws ConfigurationException, XmlPullParserException {
        String attributeValue;
        String initial;
        State rootState = this.createRootState();
        StateMachineModel smm = this.createStateMachine(rootState);
        smm.setNamespace(namespace);
        String auxString = scxmlParser.getAttributeValue(namespace, NAME);
        if (auxString != null) {
            smm.setName(auxString);
        }
        if ((initial = scxmlParser.getAttributeValue(namespace, INITIAL)) != null) {
            rootState.setInitialStateName(initial);
        }
        if ((attributeValue = scxmlParser.getAttributeValue(namespace, "version")) == null) {
            throw new ConfigurationException("The version attribute is mandatory.");
        }
        float auxFloat = this.parseFloat(attributeValue);
        if (auxFloat != -1.0f) {
            smm.setVersion(new BigDecimal(auxFloat));
        }
        return smm;
    }

    private float parseFloat(String attributeValue) throws ConfigurationException {
        float result = -1.0f;
        try {
            result = Float.parseFloat(attributeValue);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Error parsing float", (Throwable)e);
        }
        return result;
    }

    private Long parseLong(String attributeValue) throws ConfigurationException {
        Long result = null;
        try {
            result = Long.parseLong(attributeValue);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Error parsing long", (Throwable)e);
        }
        return result;
    }

    public static void main(String[] args) {
        URI uri = URI.create("fsm://sessionId/sendEvent/eventName");
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        System.out.println("schemeSpecificPart: " + schemeSpecificPart);
        System.out.println("path: " + uri.getPath());
        String[] pathParts = uri.getPath().split("/");
        System.out.println("action: " + pathParts[1]);
        System.out.println("event: " + pathParts[2]);
        System.out.println("host: " + uri.getHost());
        System.out.println("authority: " + uri.getAuthority());
        uri = URI.create("fsm:///sendEvent");
        System.out.println("host2: " + uri.getHost());
    }
}

