/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.commons.java8;

import com.numdata.commons.java8.FunctionTools;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import org.junit.Assert;
import org.junit.Test;

public class TestFunctionTools {
    @Test
    public void testWrapFunctionException() {
        Function wrappedFunction = FunctionTools.wrapFunctionException(TestFunctionTools::throwingFunction);
        System.out.println(" - Test #1: no exception");
        Assert.assertEquals((String)"Test #1 result", (Object)0, wrappedFunction.apply(0));
        System.out.println(" - Test #2: RuntimeException");
        try {
            wrappedFunction.apply(1);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            wrappedFunction.apply(2);
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            wrappedFunction.apply(3);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((String)"Expect wrapped exception with original cause", (Object)e.getCause());
            Assert.assertEquals((String)"Unexpected cause type", Exception.class, e.getCause().getClass());
        }
    }

    @Test
    public void testLiftFunctionException() throws Exception {
        Function wrappedFunction = FunctionTools.liftFunctionException(TestFunctionTools::throwingFunction);
        System.out.println(" - Test #1: no exception");
        Assert.assertEquals((String)"Test #1 result", (Object)0, wrappedFunction.apply(0));
        System.out.println(" - Test #2: RuntimeException");
        try {
            wrappedFunction.apply(1);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            wrappedFunction.apply(2);
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            wrappedFunction.apply(3);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"3", (Object)e.getMessage());
        }
    }

    @Test
    public void testWrapBiFunctionException() {
        BiFunction wrappedBiFunction = FunctionTools.wrapBiFunctionException(TestFunctionTools::throwingBiFunction);
        System.out.println(" - Test #1: no exception");
        Assert.assertEquals((String)"Test #1 result", (Object)1, wrappedBiFunction.apply(0, 1));
        System.out.println(" - Test #2: RuntimeException");
        try {
            wrappedBiFunction.apply(1, 0);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            wrappedBiFunction.apply(2, 0);
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            wrappedBiFunction.apply(3, 0);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((String)"Expect wrapped exception with original cause", (Object)e.getCause());
            Assert.assertEquals((String)"Unexpected cause type", Exception.class, e.getCause().getClass());
        }
    }

    @Test
    public void testLiftBiFunctionException() throws Exception {
        BiFunction wrappedBiFunction = FunctionTools.liftBiFunctionException(TestFunctionTools::throwingBiFunction);
        System.out.println(" - Test #1: no exception");
        Assert.assertEquals((String)"Test #1 result", (Object)1, wrappedBiFunction.apply(0, 1));
        System.out.println(" - Test #2: RuntimeException");
        try {
            wrappedBiFunction.apply(1, 0);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            wrappedBiFunction.apply(2, 0);
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            wrappedBiFunction.apply(3, 0);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"3", (Object)e.getMessage());
        }
    }

    @Test
    public void testWrapConsumerException() {
        Consumer wrappedConsumer = FunctionTools.wrapConsumerException(TestFunctionTools::throwingFunction);
        System.out.println(" - Test #1: no exception");
        wrappedConsumer.accept(0);
        System.out.println(" - Test #2: RuntimeException");
        try {
            wrappedConsumer.accept(1);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            wrappedConsumer.accept(2);
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            wrappedConsumer.accept(3);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((String)"Expect wrapped exception with original cause", (Object)e.getCause());
            Assert.assertEquals((String)"Unexpected cause type", Exception.class, e.getCause().getClass());
        }
    }

    @Test
    public void testLiftConsumerException() throws Exception {
        Consumer wrappedConsumer = FunctionTools.liftConsumerException(TestFunctionTools::throwingFunction);
        System.out.println(" - Test #1: no exception");
        wrappedConsumer.accept(0);
        System.out.println(" - Test #2: RuntimeException");
        try {
            wrappedConsumer.accept(1);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            wrappedConsumer.accept(2);
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            wrappedConsumer.accept(3);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"3", (Object)e.getMessage());
        }
    }

    @Test
    public void testWrapIntConsumerException() {
        IntConsumer wrappedIntConsumer = FunctionTools.wrapIntConsumerException(TestFunctionTools::throwingFunction);
        System.out.println(" - Test #1: no exception");
        wrappedIntConsumer.accept(0);
        System.out.println(" - Test #2: RuntimeException");
        try {
            wrappedIntConsumer.accept(1);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            wrappedIntConsumer.accept(2);
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            wrappedIntConsumer.accept(3);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((String)"Expect wrapped exception with original cause", (Object)e.getCause());
            Assert.assertEquals((String)"Unexpected cause type", Exception.class, e.getCause().getClass());
        }
    }

    @Test
    public void testLiftIntConsumerException() throws Exception {
        IntConsumer wrappedIntConsumer = FunctionTools.liftIntConsumerException(TestFunctionTools::throwingFunction);
        System.out.println(" - Test #1: no exception");
        wrappedIntConsumer.accept(0);
        System.out.println(" - Test #2: RuntimeException");
        try {
            wrappedIntConsumer.accept(1);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            wrappedIntConsumer.accept(2);
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            wrappedIntConsumer.accept(3);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"3", (Object)e.getMessage());
        }
    }

    @Test
    public void testWrapSupplierException() {
        System.out.println(" - Test #1: no exception");
        FunctionTools.wrapSupplierException(() -> 0).get();
        System.out.println(" - Test #2: RuntimeException");
        try {
            FunctionTools.wrapSupplierException(() -> {
                throw new RuntimeException("1");
            }).get();
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            FunctionTools.wrapSupplierException(() -> {
                throw new Error("2");
            }).get();
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            FunctionTools.wrapSupplierException(() -> {
                throw new Exception("3");
            }).get();
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((String)"Expect wrapped exception with original cause", (Object)e.getCause());
            Assert.assertEquals((String)"Unexpected cause type", Exception.class, e.getCause().getClass());
        }
    }

    @Test
    public void testLiftSupplierException() {
        System.out.println(" - Test #1: no exception");
        FunctionTools.liftSupplierException(() -> 0).get();
        System.out.println(" - Test #2: RuntimeException");
        try {
            FunctionTools.liftSupplierException(() -> {
                throw new RuntimeException("1");
            }).get();
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            FunctionTools.liftSupplierException(() -> {
                throw new Error("2");
            }).get();
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            FunctionTools.liftSupplierException(() -> {
                throw new Exception("3");
            }).get();
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"3", (Object)e.getMessage());
        }
    }

    @Test
    public void testWrapIntSupplierException() {
        System.out.println(" - Test #1: no exception");
        FunctionTools.wrapIntSupplierException(() -> 0).getAsInt();
        System.out.println(" - Test #2: RuntimeException");
        try {
            FunctionTools.wrapIntSupplierException(() -> {
                throw new RuntimeException("1");
            }).getAsInt();
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            FunctionTools.wrapIntSupplierException(() -> {
                throw new Error("2");
            }).getAsInt();
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            FunctionTools.wrapIntSupplierException(() -> {
                throw new Exception("3");
            }).getAsInt();
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((String)"Expect wrapped exception with original cause", (Object)e.getCause());
            Assert.assertEquals((String)"Unexpected cause type", Exception.class, e.getCause().getClass());
        }
    }

    @Test
    public void testLiftIntSupplierException() {
        System.out.println(" - Test #1: no exception");
        FunctionTools.liftIntSupplierException(() -> 0).getAsInt();
        System.out.println(" - Test #2: RuntimeException");
        try {
            FunctionTools.liftIntSupplierException(() -> {
                throw new RuntimeException("1");
            }).getAsInt();
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"1", (Object)e.getMessage());
        }
        System.out.println(" - Test #3: Error");
        try {
            FunctionTools.liftIntSupplierException(() -> {
                throw new Error("2");
            }).getAsInt();
            Assert.fail((String)"Should have thrown Error");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"2", (Object)e.getMessage());
        }
        System.out.println(" - Test #4: Exception");
        try {
            FunctionTools.liftIntSupplierException(() -> {
                throw new Exception("3");
            }).getAsInt();
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Unexpected exception message", (Object)"3", (Object)e.getMessage());
        }
    }

    public static int throwingFunction(int input) throws Exception {
        switch (input) {
            case 1: {
                throw new RuntimeException("1");
            }
            case 2: {
                throw new Error("2");
            }
            case 3: {
                throw new Exception("3");
            }
        }
        return input;
    }

    public static int throwingBiFunction(int input1, int input2) throws Exception {
        switch (input1) {
            case 1: {
                throw new RuntimeException("1");
            }
            case 2: {
                throw new Error("2");
            }
            case 3: {
                throw new Exception("3");
            }
        }
        return input2;
    }
}

