/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.commons.java8;

import com.numdata.commons.java8.FunctionTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;

public final class NioTools {
    private NioTools() {
    }

    public static void unzip(@NotNull Path toDirectory, @NotNull Path zipFile) throws IOException {
        try (InputStream in = Files.newInputStream(zipFile, new OpenOption[0]);){
            NioTools.unzip(toDirectory, in);
        }
    }

    public static void unzip(@NotNull Path toDirectory, @NotNull InputStream in) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                Path file = toDirectory.resolve(entry.getName().replace('\\', File.separatorChar));
                if (entry.isDirectory()) {
                    Files.createDirectories(file, new FileAttribute[0]);
                } else {
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                    Files.copy(zipIn, file, StandardCopyOption.REPLACE_EXISTING);
                }
                entry = zipIn.getNextEntry();
            }
        }
    }

    public static void copyFilesRecursively(final @NotNull Path fromDirectory, final @NotNull Path toDirectory) throws IOException {
        if (!Files.exists(toDirectory, new LinkOption[0])) {
            Files.createDirectories(toDirectory, new FileAttribute[0]);
        }
        Files.walkFileTree(fromDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (!dir.equals(fromDirectory)) {
                    Files.createDirectories(toDirectory.resolve(fromDirectory.relativize(dir)), new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, toDirectory.resolve(fromDirectory.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteRecursively(@NotNull Path path) throws IOException {
        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(FunctionTools.liftConsumerException(Files::delete));
    }
}

