/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.commons.java8;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public final class StreamTools {
    private StreamTools() {
    }

    @NotNull
    public static <T> Stream<T> stream(@NotNull Iterable<T> iterable) {
        return StreamTools.stream(iterable.iterator());
    }

    @NotNull
    public static <T> Stream<T> stream(@NotNull Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }

    @NotNull
    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends U> valueMapper, @NotNull Supplier<M> mapSupplier) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, mapSupplier);
    }

    @NotNull
    public static <T> Set<T> toSet(@NotNull Stream<T> stream) {
        return StreamTools.toSet(stream, HashSet::new);
    }

    @NotNull
    public static <T> Set<T> toSet(@NotNull Stream<T> stream, @NotNull Supplier<Set<T>> setSupplier) {
        BiFunction<Set, Object, Set> accumulator = (set, i) -> {
            Set result = set.isEmpty() ? (Set)setSupplier.get() : set;
            result.add(i);
            return result;
        };
        BinaryOperator combiner = (set1, set2) -> {
            Set result;
            if (set1.isEmpty()) {
                result = set2;
            } else {
                set1.addAll(set2);
                result = set1;
            }
            return result;
        };
        return stream.reduce(Collections.emptySet(), accumulator, combiner);
    }
}

