/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.commons.java8;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaitingFutureTask<T>
extends FutureTask<T> {
    private final Semaphore semaphore = new Semaphore(1);

    public WaitingFutureTask(@NotNull Runnable runnable, @Nullable T result) {
        this(Executors.callable(runnable, result));
    }

    public WaitingFutureTask(@NotNull Callable<T> callable) {
        this(new MyCallable<T>(callable));
    }

    private WaitingFutureTask(@NotNull MyCallable<T> myCallable) {
        super(myCallable);
        myCallable.task = this;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException, CancellationException {
        try {
            return (T)super.get();
        }
        catch (CancellationException e) {
            this.semaphore.acquire();
            this.semaphore.release();
            throw e;
        }
    }

    @Override
    public T get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, CancellationException, TimeoutException {
        try {
            return (T)super.get(timeout, unit);
        }
        catch (CancellationException e) {
            this.semaphore.acquire();
            this.semaphore.release();
            throw e;
        }
    }

    public void cancelAndWait(boolean mayInterruptIfRunning) throws InterruptedException {
        this.cancel(mayInterruptIfRunning);
        this.semaphore.acquire();
        this.semaphore.release();
    }

    public boolean cancelAndWait(boolean mayInterruptIfRunning, int timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        this.cancel(mayInterruptIfRunning);
        boolean result = this.semaphore.tryAcquire(timeout, timeUnit);
        if (result) {
            this.semaphore.release();
        }
        return result;
    }

    private static class MyCallable<T>
    implements Callable<T> {
        final Callable<T> callable;
        WaitingFutureTask<T> task;

        MyCallable(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public T call() throws Exception {
            ((WaitingFutureTask)this.task).semaphore.acquire();
            try {
                if (this.task.isCancelled()) {
                    T t = null;
                    return t;
                }
                T t = this.callable.call();
                return t;
            }
            finally {
                ((WaitingFutureTask)this.task).semaphore.release();
            }
        }
    }
}

