/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.serial;

import com.numdata.oss.TextTools;
import com.numdata.serial.Javacomm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class JavacommApp {
    private boolean _hexdump;
    private int _hexDumpBytesWritten = 0;
    private int _hexDumpWidth = 20;
    private boolean _noCarriageReturn;

    public void setHexdump(boolean hexdump) {
        this._hexdump = hexdump;
    }

    public boolean isHexdump() {
        return this._hexdump;
    }

    public int getHexDumpWidth() {
        return this._hexDumpWidth;
    }

    public void setHexDumpWidth(int hexDumpWidth) {
        this._hexDumpWidth = hexDumpWidth;
    }

    public void setNoCarriageReturn(boolean noCarriageReturn) {
        this._noCarriageReturn = noCarriageReturn;
    }

    public boolean isNoCarriageReturn() {
        return this._noCarriageReturn;
    }

    private void listSerialPorts() {
        Javacomm javacomm = Javacomm.getInstance();
        List<String> serialPortNames = javacomm.getSerialPortNames();
        if (serialPortNames.isEmpty()) {
            System.out.println("No serial ports available.");
        } else {
            System.out.println("Available serial ports:");
            for (String name : serialPortNames) {
                System.out.println("  " + name);
            }
        }
    }

    private void listenToPort(String portName) throws IOException {
        int b;
        Javacomm jc = Javacomm.getInstance();
        System.out.println("Opening port '" + portName + '\'');
        Javacomm.SerialPort port = jc.openSerialPort(portName, 9600, Javacomm.DataBits.EIGHT, Javacomm.Parity.NONE, Javacomm.StopBits.ONE);
        System.out.println("Listening");
        InputStream is = port.getInputStream();
        while ((b = is.read()) >= 0) {
            System.out.println(TextTools.toHexString((int)b, (int)2, (boolean)true) + ' ' + TextTools.getFixed((String)String.valueOf(b), (int)3, (boolean)true, (char)' ') + " '" + (char)b + '\'');
        }
        System.out.println("Port closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToPort(String port) throws IOException {
        Javacomm jc = Javacomm.getInstance();
        try (Javacomm.SerialPort serialPort = jc.openSerialPort(URI.create("serial:" + port));){
            int b;
            OutputStream out = serialPort.getOutputStream();
            while ((b = System.in.read()) != -1) {
                if (this.isNoCarriageReturn() && b == 13) continue;
                out.write(b);
                if (!this.isHexdump()) continue;
                this.hexDump(b);
            }
            out.close();
        }
    }

    private void hexDump(int b) {
        System.out.print(TextTools.toHexString((int)b, (int)2, (boolean)false));
        if (++this._hexDumpBytesWritten % this._hexDumpWidth == 0) {
            System.out.println();
        } else {
            System.out.print(' ');
        }
    }

    public static void main(String[] args) throws Exception {
        JavacommApp app = new JavacommApp();
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        Iterator iterator = arguments.iterator();
        while (iterator.hasNext()) {
            String argument = (String)iterator.next();
            if (!argument.startsWith("--")) continue;
            if ("--hexdump".equals(argument)) {
                app.setHexdump(true);
            } else if ("--nocr".equals(argument)) {
                app.setNoCarriageReturn(true);
            } else {
                System.err.println("Unknown option: " + args);
            }
            iterator.remove();
        }
        if (arguments.isEmpty()) {
            System.err.println("Usage:");
            System.err.println("  list           List all serial ports.");
            System.err.println("  listen PORT    Print incoming data from specified PORT on standard output.");
            System.err.println("  send PORT      Send data from standard input to specified PORT.");
            System.err.println();
            System.err.println("Options:");
            System.err.println("  --hexdump      Print transmitted bytes in hexadecimal format.");
            System.err.println("  --nocr         Send no carriage return characters.");
        } else {
            String port;
            String command = (String)arguments.remove(0);
            if ("list".equals(command)) {
                app.listSerialPorts();
            } else if ("listen".equals(command)) {
                port = (String)arguments.remove(0);
                app.listenToPort(port);
            } else if ("send".equals(command)) {
                port = (String)arguments.remove(0);
                app.sendToPort(port);
            } else {
                System.err.println("Unsupported command: " + command);
            }
        }
    }
}

