/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.serial;

import com.numdata.oss.TextTools;
import com.numdata.oss.log.ClassLogger;
import com.numdata.serial.Javacomm;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TooManyListenersException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavacommRxTxImpl
extends Javacomm {
    private static final ClassLogger LOG = ClassLogger.getFor(JavacommRxTxImpl.class);

    JavacommRxTxImpl() {
        CommPortIdentifier.getPortIdentifiers();
    }

    @Override
    @NotNull
    public List<String> getSerialPortNames() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration e = CommPortIdentifier.getPortIdentifiers();
        while (e.hasMoreElements()) {
            CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
            if (id.getPortType() != 1) continue;
            result.add(id.getName());
        }
        return result;
    }

    @Nullable
    public CommPortIdentifier getPortByName(@NotNull String name) {
        CommPortIdentifier result = null;
        Enumeration e = CommPortIdentifier.getPortIdentifiers();
        while (e.hasMoreElements()) {
            CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
            if (id.getPortType() != 1 || !name.equalsIgnoreCase(id.getName())) continue;
            result = id;
            break;
        }
        return result;
    }

    @Override
    public Javacomm.SerialPort openSerialPort(@NotNull String portName, int baudrate, @NotNull Javacomm.DataBits databits, @NotNull Javacomm.Parity parity, @NotNull Javacomm.StopBits stopbits) throws IOException {
        SerialPort port;
        int rxtxStopbits;
        int rxtxParity;
        int rxtxDatabits;
        CommPortIdentifier commPortIdentifier = this.getPortByName(portName);
        if (commPortIdentifier == null) {
            String filteredPortName = portName;
            if (TextTools.endsWith((CharSequence)filteredPortName, (char)':')) {
                filteredPortName = filteredPortName.substring(0, filteredPortName.length() - 1);
            }
            if (filteredPortName.startsWith("/dev/")) {
                filteredPortName = filteredPortName.substring(5);
            }
            commPortIdentifier = this.getPortByName(filteredPortName);
        }
        if (commPortIdentifier == null) {
            throw new IOException("Could not find serial port '" + portName + "'!");
        }
        switch (databits) {
            case FIVE: {
                rxtxDatabits = 5;
                break;
            }
            case SIX: {
                rxtxDatabits = 6;
                break;
            }
            case SEVEN: {
                rxtxDatabits = 7;
                break;
            }
            default: {
                rxtxDatabits = 8;
            }
        }
        switch (parity) {
            case ODD: {
                rxtxParity = 1;
                break;
            }
            case EVEN: {
                rxtxParity = 2;
                break;
            }
            case MARK: {
                rxtxParity = 3;
                break;
            }
            case SPACE: {
                rxtxParity = 4;
                break;
            }
            default: {
                rxtxParity = 0;
            }
        }
        switch (stopbits) {
            case TWO: {
                rxtxStopbits = 2;
                break;
            }
            case ONE_AND_A_HALF: {
                rxtxStopbits = 3;
                break;
            }
            default: {
                rxtxStopbits = 1;
            }
        }
        try {
            Method openMethod = JavacommRxTxImpl.getMethod(commPortIdentifier, "open", String.class, Integer.TYPE);
            port = (SerialPort)JavacommRxTxImpl.callMethod((Object)commPortIdentifier, openMethod, this.getClass().getName(), 2000);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PortInUseException) {
                String message = "Serial port '" + portName + "' already in use";
                LOG.error(message, cause);
                throw new IOException(message, cause);
            }
            String message = "Could not open port '" + portName + "': " + e;
            LOG.error(message, cause);
            throw new IOException(message, cause);
        }
        try {
            port.setSerialPortParams(baudrate, rxtxDatabits, rxtxStopbits, rxtxParity);
        }
        catch (UnsupportedCommOperationException e) {
            String message = "Serial port '" + portName + "' does not accept specified settings (" + baudrate + ',' + (Object)((Object)databits) + ',' + (Object)((Object)stopbits) + ',' + (Object)((Object)parity) + ')';
            LOG.error(message, (Throwable)e);
            throw new IOException(message, e);
        }
        return new Javacomm.SerialPort(){

            @Override
            public void close() {
                port.close();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return port.getInputStream();
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return port.getOutputStream();
            }

            @Override
            public String getName() {
                return port.getName();
            }

            @Override
            public void addEventListener(final Javacomm.SerialPortDataAvailableEventListener listener) throws TooManyListenersException {
                port.addEventListener(new SerialPortEventListener(){

                    public void serialEvent(SerialPortEvent serialPortEvent) {
                        listener.serialPortDataAvailable(new Javacomm.SerialPortDataAvailableEvent(serialPortEvent.getSource()));
                    }
                });
                port.notifyOnDataAvailable(true);
            }

            @Override
            public void removeEventListener() {
                port.removeEventListener();
            }
        };
    }

    public static Object callMethod(Object object, String methodName, Object ... args) throws InvocationTargetException {
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            parameterTypes[i] = arg == null ? Object.class : arg.getClass();
        }
        Method method = JavacommRxTxImpl.getMethod(object, methodName, parameterTypes);
        return JavacommRxTxImpl.callMethod(object, method, args);
    }

    public static Object callMethod(Object object, Method method, Object ... args) throws InvocationTargetException {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(method + " not accessible for " + object, e);
        }
    }

    public static Method getMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        Class<?> aClass = object.getClass();
        try {
            return aClass.getMethod(methodName, parameterTypes);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

