/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.serial;

import com.numdata.oss.TextTools;
import com.numdata.oss.log.ClassLogger;
import com.numdata.serial.JavacommNullImpl;
import com.numdata.serial.JavacommRxTxImpl;
import com.numdata.serial.JavacommSunImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.TooManyListenersException;
import org.jetbrains.annotations.NotNull;

public abstract class Javacomm {
    private static final ClassLogger LOG = ClassLogger.getFor(Javacomm.class);

    public static Javacomm getInstance() {
        Constructor defaultConstructor;
        Class implClass;
        LOG.trace("JavaComm.getInstance");
        Javacomm result = null;
        try {
            implClass = JavacommSunImpl.class;
            defaultConstructor = implClass.getDeclaredConstructor(new Class[0]);
            result = (Javacomm)defaultConstructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            LOG.trace("Sun implementation is not available");
        }
        if (result == null) {
            try {
                implClass = JavacommRxTxImpl.class;
                defaultConstructor = implClass.getDeclaredConstructor(new Class[0]);
                result = (Javacomm)defaultConstructor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                LOG.trace("RXTX implementation is not available");
            }
        }
        if (result == null) {
            result = new JavacommNullImpl();
        }
        return result;
    }

    @NotNull
    public abstract List<String> getSerialPortNames();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToSerialPort(URI uri, byte[] data) throws IOException {
        SerialPort port = this.openSerialPort(uri);
        try {
            OutputStream out = port.getOutputStream();
            out.write(data);
        }
        finally {
            port.close();
        }
    }

    public SerialPort openSerialPort(URI uri) throws IOException {
        String[] schemeSpecificParts = TextTools.tokenize((String)uri.getSchemeSpecificPart(), (char)';');
        String portName = schemeSpecificParts[0];
        if (TextTools.isEmpty((CharSequence)portName)) {
            throw new IOException("Missing port name in URI: " + uri);
        }
        int baudrate = 9600;
        DataBits databits = DataBits.EIGHT;
        Parity parity = Parity.NONE;
        StopBits stopbits = StopBits.ONE;
        for (int i = 1; i < schemeSpecificParts.length; ++i) {
            String value;
            String parameter = schemeSpecificParts[i];
            int equals = parameter.indexOf(61);
            String name = equals >= 0 ? parameter.substring(0, equals) : parameter;
            String string = value = equals >= 0 ? parameter.substring(equals + 1) : null;
            if ("baudrate".equals(name)) {
                try {
                    baudrate = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Bad '" + name + "' in URI: " + uri, nfe);
                }
            }
            if ("databits".equals(name)) {
                if ("5".equals(value)) {
                    databits = DataBits.FIVE;
                    continue;
                }
                if ("6".equals(value)) {
                    databits = DataBits.SIX;
                    continue;
                }
                if ("7".equals(value)) {
                    databits = DataBits.SEVEN;
                    continue;
                }
                if ("8".equals(value)) {
                    databits = DataBits.EIGHT;
                    continue;
                }
                throw new IOException("Bad '" + name + "' in URI: " + uri);
            }
            if ("parity".equals(name)) {
                if ("even".equals(value)) {
                    parity = Parity.EVEN;
                    continue;
                }
                if ("mark".equals(value)) {
                    parity = Parity.MARK;
                    continue;
                }
                if ("none".equals(value)) {
                    parity = Parity.NONE;
                    continue;
                }
                if ("odd".equals(value)) {
                    parity = Parity.ODD;
                    continue;
                }
                if ("space".equals(value)) {
                    parity = Parity.SPACE;
                    continue;
                }
                throw new IOException("Bad '" + name + "' in URI: " + uri);
            }
            if ("stopbits".equals(name)) {
                if ("1".equals(value)) {
                    stopbits = StopBits.ONE;
                    continue;
                }
                if ("1.5".equals(value)) {
                    stopbits = StopBits.ONE_AND_A_HALF;
                    continue;
                }
                if ("2".equals(value)) {
                    stopbits = StopBits.TWO;
                    continue;
                }
                throw new IOException("Bad '" + name + "' in URI: " + uri);
            }
            throw new IOException("Unrecognized '" + parameter + "' in URI: " + uri);
        }
        return this.openSerialPort(portName, baudrate, databits, parity, stopbits);
    }

    public abstract SerialPort openSerialPort(@NotNull String var1, int var2, @NotNull DataBits var3, @NotNull Parity var4, @NotNull StopBits var5) throws IOException;

    public static class SerialPortDataAvailableEvent
    extends EventObject {
        private static final long serialVersionUID = -5000071576142762147L;

        public SerialPortDataAvailableEvent(Object source) {
            super(source);
        }
    }

    public static interface SerialPortDataAvailableEventListener
    extends EventListener {
        public void serialPortDataAvailable(SerialPortDataAvailableEvent var1);
    }

    public static interface SerialPort {
        public String getName();

        public void close();

        public InputStream getInputStream() throws IOException;

        public OutputStream getOutputStream() throws IOException;

        public void addEventListener(SerialPortDataAvailableEventListener var1) throws TooManyListenersException;

        public void removeEventListener();
    }

    public static enum StopBits {
        ONE,
        ONE_AND_A_HALF,
        TWO;

    }

    public static enum Parity {
        NONE,
        ODD,
        EVEN,
        MARK,
        SPACE;

    }

    public static enum DataBits {
        FIVE,
        SIX,
        SEVEN,
        EIGHT;

    }
}

