/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.serial;

import com.numdata.oss.TextTools;
import com.numdata.oss.log.ClassLogger;
import com.numdata.serial.Javacomm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import org.jetbrains.annotations.NotNull;

class JavacommSunImpl
extends Javacomm {
    private static final ClassLogger LOG = ClassLogger.getFor(JavacommSunImpl.class);

    JavacommSunImpl() {
        CommPortIdentifier.getPortIdentifiers();
    }

    @Override
    @NotNull
    public List<String> getSerialPortNames() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration e = CommPortIdentifier.getPortIdentifiers();
        while (e.hasMoreElements()) {
            CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
            if (id.getPortType() != 1) continue;
            result.add(id.getName());
        }
        return result;
    }

    @Override
    public Javacomm.SerialPort openSerialPort(@NotNull String portName, int baudrate, @NotNull Javacomm.DataBits databits, @NotNull Javacomm.Parity parity, @NotNull Javacomm.StopBits stopbits) throws IOException {
        SerialPort port;
        int rxtxStopbits;
        int rxtxParity;
        int rxtxDatabits;
        String filteredPorTName = portName;
        if (TextTools.endsWith((CharSequence)filteredPorTName, (char)':')) {
            filteredPorTName = filteredPorTName.substring(0, filteredPorTName.length() - 1);
        }
        if (filteredPorTName.startsWith("/dev/")) {
            filteredPorTName = filteredPorTName.substring(5);
        }
        CommPortIdentifier commPortIdentifier = null;
        Enumeration e = CommPortIdentifier.getPortIdentifiers();
        while (e.hasMoreElements()) {
            CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
            if (id.getPortType() != 1 || !filteredPorTName.equalsIgnoreCase(id.getName())) continue;
            commPortIdentifier = id;
            break;
        }
        if (commPortIdentifier == null) {
            throw new IOException("Could not find serial port '" + portName + "'!");
        }
        switch (databits) {
            case FIVE: {
                rxtxDatabits = 5;
                break;
            }
            case SIX: {
                rxtxDatabits = 6;
                break;
            }
            case SEVEN: {
                rxtxDatabits = 7;
                break;
            }
            default: {
                rxtxDatabits = 8;
            }
        }
        switch (parity) {
            case ODD: {
                rxtxParity = 1;
                break;
            }
            case EVEN: {
                rxtxParity = 2;
                break;
            }
            case MARK: {
                rxtxParity = 3;
                break;
            }
            case SPACE: {
                rxtxParity = 4;
                break;
            }
            default: {
                rxtxParity = 0;
            }
        }
        switch (stopbits) {
            case TWO: {
                rxtxStopbits = 2;
                break;
            }
            case ONE_AND_A_HALF: {
                rxtxStopbits = 3;
                break;
            }
            default: {
                rxtxStopbits = 1;
            }
        }
        try {
            port = (SerialPort)commPortIdentifier.open(this.getClass().getName(), 2000);
        }
        catch (PortInUseException e2) {
            String message = "Serial port '" + portName + "' already in use";
            LOG.error(message, (Throwable)e2);
            throw new IOException(message, e2);
        }
        try {
            port.setSerialPortParams(baudrate, rxtxDatabits, rxtxStopbits, rxtxParity);
        }
        catch (UnsupportedCommOperationException e3) {
            String message = "Serial port '" + portName + "' does not accept specified settings (" + baudrate + ',' + (Object)((Object)databits) + ',' + (Object)((Object)stopbits) + ',' + (Object)((Object)parity) + ')';
            LOG.error(message, (Throwable)e3);
            throw new IOException(message, e3);
        }
        return new Javacomm.SerialPort(){

            @Override
            public void close() {
                port.close();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return port.getInputStream();
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return port.getOutputStream();
            }

            @Override
            public String getName() {
                return port.getName();
            }

            @Override
            public void addEventListener(final Javacomm.SerialPortDataAvailableEventListener listener) throws TooManyListenersException {
                port.addEventListener(new SerialPortEventListener(){

                    public void serialEvent(SerialPortEvent serialPortEvent) {
                        listener.serialPortDataAvailable(new Javacomm.SerialPortDataAvailableEvent(serialPortEvent.getSource()));
                    }
                });
                port.notifyOnDataAvailable(true);
            }

            @Override
            public void removeEventListener() {
                port.removeEventListener();
            }
        };
    }
}

