/*
 * Copyright (c) 2006-2017, Numdata BV, The Netherlands.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Numdata nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL NUMDATA BV BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.numdata.oss.web;

import java.util.List;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Default implementation of HTMLTableFactory interface.
 *
 * @author  Peter S. Heijnen
 */
public class HTMLTableFactoryImpl
	implements HTMLTableFactory
{
	public final HTMLTable createTable( final int columnCount )
	{
		return createTableImpl( null , columnCount );
	}

	public final HTMLTable createTable( @Nullable final String title , final int columnCount )
	{
		return createTableImpl( ( title == null ) ? null : new String[] { title } , columnCount );
	}

	public final HTMLTable createTable( @NotNull final List<String> columnNames )
	{
		return createTableImpl( columnNames.toArray( new String[ columnNames.size() ] ) , columnNames.size() );
	}

	public final HTMLTable createTable( @NotNull final String... columnNames )
	{
		return createTableImpl( columnNames , columnNames.length );
	}

	/**
	 * Create a HTML item table. See HTMLTable class for details.
	 *
	 * @param   columnNames     Name for each column (just one item if using single title).
	 * @param   columnCount     Number of columns.
	 *
	 * @return  Table generator instance (HTMLTable).
	 */
	protected HTMLTable createTableImpl( @Nullable final String[] columnNames , final int columnCount )
	{
		return new HTMLTable( columnNames , columnCount );
	}

}
