/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.support;

import com.objectsql.annotation.RdColumn;
import com.objectsql.support.ColumnInfo;
import com.objectsql.support.ColumnType;
import com.objectsql.support.LambdaQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Pair
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String name;
    private String type;
    private Object value;
    private String column;
    private ColumnType columnType;
    private Map<String, Object> metadata;

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public void setColumnType(ColumnType columnType) {
        this.columnType = columnType;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public <T, R> void setColumn(LambdaQuery<T, R> lambdaQuery) {
        this.column = lambdaQuery.getColumnName();
    }

    public Pair(ColumnInfo info, Object value) {
        this.value = value;
        if (info != null) {
            RdColumn column;
            this.name = info.getName();
            this.columnType = info.getColumnType();
            this.type = info.getType();
            this.column = info.getColumnName();
            if (info.getField() != null && (column = info.getField().getAnnotation(RdColumn.class)) != null) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("runningMode", column.runningMode());
                data.put("scale", column.scale());
                data.put("precision", column.precision());
                data.put("coding", column.coding());
                this.metadata = data;
            }
        }
    }

    public Pair(String name, Object value) {
        this.name = name;
        this.value = value;
        if (value != null) {
            this.type = value.getClass().getSimpleName();
        }
    }

    public Pair(Object value) {
        this.value = value;
        if (value != null) {
            this.type = value.getClass().getSimpleName();
        }
    }

    public Pair(Object value, ColumnType columnType) {
        this.value = value;
        if (value != null) {
            this.type = value.getClass().getSimpleName();
        }
        this.columnType = columnType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "{" + (this.column == null || "".equals(this.column) ? "" : this.column + ":") + (this.value instanceof Date && this.columnType == ColumnType.LONG ? (this.value instanceof Long ? this.value : Long.valueOf(((Date)this.value).getTime())) : this.value) + "}";
    }
}

