/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.query;

import com.objectsql.annotation.RdTable;
import com.objectsql.query.AbstractQueryImpl;
import com.objectsql.query.Query;
import com.objectsql.query.QueryUtils;
import com.objectsql.spring.SpringUtils;
import com.objectsql.support.Column;
import com.objectsql.support.Columns;
import com.objectsql.support.Condition;
import com.objectsql.support.Expression;
import com.objectsql.support.ExpressionType;
import com.objectsql.support.LambdaQuery;
import com.objectsql.support.Order;
import com.objectsql.support.QueryInfo;
import com.objectsql.utils.ORMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class QueryImpl
extends AbstractQueryImpl
implements Query {
    private Class<?> table;
    private Class<?> returnClass;
    private List<Column> returnColumns = new ArrayList<Column>();
    private List<Column> fixedReturnColumns = new ArrayList<Column>();
    private List<Column> groups = new ArrayList<Column>();
    private List<Column> groupCountsSelectColumns = new ArrayList<Column>();

    @Override
    public Query orderDesc(String name) {
        this.orders.add(new Order(new Column(name), "DESC"));
        return this;
    }

    @Override
    public Query whereIsNull(String name) {
        this.addCondition(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_NULL)));
        return this;
    }

    @Override
    public Query whereIsNotNull(String name) {
        this.addCondition(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_NOT_NULL)));
        return this;
    }

    @Override
    public Query whereIsEmpty(String name) {
        this.addCondition(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_EMPTY)));
        return this;
    }

    @Override
    public Query whereIsNotEmpty(String name) {
        this.addCondition(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_NOT_EMPTY)));
        return this;
    }

    @Override
    public <T, R> Query where(LambdaQuery<T, R> fieldFunction, ExpressionType type) {
        return this.where(fieldFunction.getColumnName(), type);
    }

    @Override
    public Query where(String name, ExpressionType type) {
        if (ExpressionType.CDT_IS_NULL == type || ExpressionType.CDT_IS_NOT_NULL == type || ExpressionType.CDT_IS_EMPTY == type || ExpressionType.CDT_IS_NOT_EMPTY == type) {
            this.addCondition(new Condition().and(new Expression(new Column(name), type)));
        }
        return this;
    }

    @Override
    public <T, R> Query whereEqual(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereEqual(fieldFunction.getColumnName(), value);
    }

    @Override
    public Query whereEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_EQUAL);
    }

    @Override
    public <T, R> Query whereNotEqual(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereNotEqual(fieldFunction.getColumnName(), value);
    }

    @Override
    public Query whereNotEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_NOT_EQUAL);
    }

    @Override
    public Query whereLike(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_LIKE);
    }

    @Override
    public Query whereNotLike(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_NOT_LIKE);
    }

    @Override
    public Query whereStartWith(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_START_WITH);
    }

    @Override
    public Query whereEndWith(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_END_WITH);
    }

    @Override
    public Query whereNotStartWith(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_NOT_START_WITH);
    }

    @Override
    public Query whereNotEndWith(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_NOT_END_WITH);
    }

    @Override
    public <T, R> Query whereLike(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereLike(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> Query whereNotLike(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereNotLike(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> Query whereStartWith(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereStartWith(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> Query whereEndWith(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereEndWith(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> Query whereNotStartWith(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereNotStartWith(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> Query whereNotEndWith(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereNotEndWith(fieldFunction.getColumnName(), value);
    }

    @Override
    public Query whereLess(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_LESS);
    }

    @Override
    public Query whereLessEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_LESS_EQUAL);
    }

    @Override
    public Query whereMore(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_MORE);
    }

    @Override
    public Query whereMoreEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_MORE_EQUAL);
    }

    @Override
    public <T, R> Query whereLess(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereLess(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> Query whereLessEqual(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereLessEqual(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> Query whereMore(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereMore(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> Query whereMoreEqual(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereMoreEqual(fieldFunction.getColumnName(), value);
    }

    @Override
    public Query whereIn(String name, Collection value) {
        return this.where(name, (Object)value, ExpressionType.CDT_IN);
    }

    @Override
    public Query whereNotIn(String name, Collection value) {
        return this.where(name, (Object)value, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public Query whereInValues(String name, Object ... values) {
        List<Object> temp = null;
        temp = values != null ? Arrays.asList(values) : new ArrayList<Object>();
        return this.where(name, temp, ExpressionType.CDT_IN);
    }

    @Override
    public Query whereNotInValues(String name, Object ... values) {
        List<Object> temp = null;
        temp = values != null ? Arrays.asList(values) : new ArrayList<Object>();
        return this.where(name, temp, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public <T, R> Query whereIn(LambdaQuery<T, R> fieldFunction, Collection value) {
        return this.whereIn(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> Query whereNotIn(LambdaQuery<T, R> fieldFunction, Collection value) {
        return this.whereNotIn(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> Query whereInValues(LambdaQuery<T, R> fieldFunction, Object ... values) {
        return this.whereInValues(fieldFunction.getColumnName(), values);
    }

    @Override
    public <T, R> Query whereNotInValues(LambdaQuery<T, R> fieldFunction, Object ... values) {
        return this.whereNotInValues(fieldFunction.getColumnName(), values);
    }

    @Override
    public Query where(String name, Object value, ExpressionType type) {
        this.addCondition(new Condition().and(new Expression(new Column(name), value, type)));
        return this;
    }

    @Override
    public <T, R> Query whereIsNull(LambdaQuery<T, R> fieldFunction) {
        return this.whereIsNull(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> Query whereIsNotNull(LambdaQuery<T, R> fieldFunction) {
        return this.whereIsNotNull(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> Query whereIsEmpty(LambdaQuery<T, R> fieldFunction) {
        return this.whereIsEmpty(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> Query whereIsNotEmpty(LambdaQuery<T, R> fieldFunction) {
        return this.whereIsNotEmpty(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> Query where(LambdaQuery<T, R> fieldFunction, Object value, ExpressionType type) {
        return this.where(fieldFunction.getColumnName(), value, type);
    }

    @Override
    public Query where(Condition condition) {
        if (condition != null) {
            this.addCondition(condition);
        }
        return this;
    }

    @Override
    public Query whereBetween(String name, Object value, Object andValue) {
        if (!ORMUtils.isEmpty(value) && !ORMUtils.isEmpty(andValue)) {
            Expression expression = new Expression(new Column(name), value, ExpressionType.CDT_BETWEEN);
            expression.setAndValue(andValue);
            this.addCondition(new Condition().and(expression));
        }
        return this;
    }

    @Override
    public <T, R> Query whereBetween(LambdaQuery<T, R> fieldFunction, Object value, Object andValue) {
        return this.whereBetween(fieldFunction.getColumnName(), value, andValue);
    }

    @Override
    public Query where(Expression ... expressions) {
        this.addCondition(new Condition().and(expressions));
        return this;
    }

    @Override
    public Query group(String name) {
        this.groups.add(new Column(name));
        return this;
    }

    @Override
    public List<Column> getGroupCountSelectColumns() {
        return this.groupCountsSelectColumns;
    }

    @Override
    public Query groupCountSelectColumn(String name) {
        this.groupCountsSelectColumns.add(new Column(name));
        return this;
    }

    @Override
    public Query having(String name, Object value, ExpressionType type) {
        if (value == null) {
            return this;
        }
        if ("".equals(value)) {
            return this;
        }
        this.addHaving(new Condition().or(new Expression(new Column(name), value, type)));
        return this;
    }

    @Override
    public <T, R> Query group(LambdaQuery<T, R> fieldFunction) {
        return this.group(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> Query groupCountSelectColumn(LambdaQuery<T, R> fieldFunction) {
        return this.groupCountSelectColumn(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> Query having(LambdaQuery<T, R> fieldFunction, Object value, ExpressionType type) {
        return this.having(fieldFunction.getColumnName(), value, type);
    }

    @Override
    public Query having(Condition condition) {
        this.addCondition(condition);
        return this;
    }

    @Override
    public Query orderAsc(String name) {
        this.orders.add(new Order(new Column(name), "ASC"));
        return this;
    }

    @Override
    public <T, R> Query orderDesc(LambdaQuery<T, R> fieldFunction) {
        return this.orderDesc(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> Query orderAsc(LambdaQuery<T, R> fieldFunction) {
        return this.orderAsc(fieldFunction.getColumnName());
    }

    @Override
    public Query order(Order order) {
        if (order != null) {
            this.orders.add(order);
        }
        return this;
    }

    @Override
    public Query orders(List<Order> os) {
        if (os != null) {
            for (Order order : os) {
                this.orders.add(order);
            }
        }
        return this;
    }

    @Override
    public <T, R> Query createQuery(LambdaQuery<T, R> ... lambdaQueries) {
        return this.createQuery(QueryUtils.getColumns(lambdaQueries));
    }

    @Override
    public <T, R> Query createQuery(Class<?> clazz, LambdaQuery<T, R> ... names) {
        return this.createQuery(clazz, QueryUtils.getColumns(names));
    }

    @Override
    public Query createQuery(Class<?> clazz, String ... names) {
        this.returnClass = clazz;
        this.returnColumns.clear();
        this.fixedReturnColumns.clear();
        if (names != null) {
            for (String name : names) {
                this.returnColumns.add(new Column(name));
            }
        }
        return this;
    }

    @Override
    public Query createQuery(Class<?> clazz, Column ... columns) {
        this.returnClass = clazz;
        this.returnColumns.clear();
        this.fixedReturnColumns.clear();
        if (columns != null) {
            for (Column column : columns) {
                this.returnColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public Query addReturnColumn(Column ... columns) {
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                this.returnColumns.add(columns[i]);
            }
        }
        return this;
    }

    @Override
    public Query addReturnColumn(String ... columns) {
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                this.returnColumns.add(new Column(columns[i]));
            }
        }
        return this;
    }

    @Override
    public Query addReturnColumn(Columns ... columns) {
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                this.returnColumns.addAll(columns[i].getColumnList());
            }
        }
        return this;
    }

    @Override
    public Query clearReturnColumns() {
        this.returnColumns.clear();
        return this;
    }

    @Override
    public Query addFixedReturnColumn(Column ... columns) {
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                this.fixedReturnColumns.add(columns[i]);
            }
        }
        return this;
    }

    @Override
    public <T, R> Query addReturnColumn(LambdaQuery<T, R> ... fieldFunctions) {
        if (fieldFunctions != null && fieldFunctions.length > 0) {
            for (int i = 0; i < fieldFunctions.length; ++i) {
                this.addReturnColumn(new Column(fieldFunctions[i]));
            }
        }
        return this;
    }

    @Override
    public <T, R> Query addFixedReturnColumn(LambdaQuery<T, R> ... fieldFunctions) {
        if (fieldFunctions != null && fieldFunctions.length > 0) {
            for (int i = 0; i < fieldFunctions.length; ++i) {
                this.addFixedReturnColumn(new Column(fieldFunctions[i]));
            }
        }
        return this;
    }

    @Override
    public Query addFixedReturnColumn(String ... columns) {
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                this.fixedReturnColumns.add(new Column(columns[i]));
            }
        }
        return this;
    }

    @Override
    public Query addFixedReturnColumn(Columns ... columns) {
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                this.fixedReturnColumns.addAll(columns[i].getColumnList());
            }
        }
        return this;
    }

    @Override
    public Query clearFixedReturnColumns() {
        this.returnColumns.clear();
        return this;
    }

    @Override
    public Query createQuery(String ... names) {
        this.returnClass = this.table;
        this.returnColumns.clear();
        this.fixedReturnColumns.clear();
        if (names != null) {
            for (String name : names) {
                this.returnColumns.add(new Column(name));
            }
        }
        return this;
    }

    public Query createQuery(Column ... columns) {
        this.returnClass = this.table;
        this.returnColumns.clear();
        this.fixedReturnColumns.clear();
        if (columns != null) {
            for (Column column : columns) {
                this.returnColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public Query distinct() {
        this.distinct = true;
        return this;
    }

    @Override
    public Query table(Class<?> clazz) {
        RdTable rdTable;
        if (clazz != null && (rdTable = SpringUtils.findAnnotation(clazz, RdTable.class)) != null) {
            this.table = clazz;
            this.returnClass = clazz;
        }
        return this;
    }

    @Override
    public Class<?> getTable() {
        return this.table;
    }

    @Override
    public List<Column> getGroups() {
        return this.groups;
    }

    @Override
    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    @Override
    public List<Column> getReturnColumns() {
        ArrayList<Column> columnList = new ArrayList<Column>();
        if (this.returnColumns.isEmpty()) {
            columnList.add(new Column("*"));
        } else {
            columnList.addAll(this.returnColumns);
        }
        return columnList;
    }

    @Override
    public List<Column> getFinalReturnColumns() {
        ArrayList<Column> columnList = new ArrayList<Column>();
        columnList.addAll(this.getReturnColumns());
        columnList.addAll(this.fixedReturnColumns);
        return columnList;
    }

    @Override
    public List<Column> getFixedReturnColumns() {
        return this.fixedReturnColumns;
    }

    @Override
    public QueryInfo doQuery() {
        return this.options.doQuery(this, this.getPageable());
    }

    @Override
    public QueryInfo doQueryCount() {
        return this.options.doQueryCount(this);
    }
}

