/*
 * Copyright 2017 @objectsql.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.objectsql.spring;

import com.objectsql.BaseServiceImpl;
import com.objectsql.BaseService;
import com.objectsql.ObjectSQLManager;
import com.objectsql.listener.*;
import com.objectsql.utils.ORMUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;

import javax.sql.DataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SpringBaseServiceImpl<T> extends BaseServiceImpl<T> implements BeanFactoryAware{

    public SpringBaseServiceImpl(){

    }

    public SpringBaseServiceImpl(ObjectSQLManager objectSQLManager){
       super(objectSQLManager);
    }

    public SpringBaseServiceImpl(DataSource dataSource){
        super(dataSource);
    }

    private ListableBeanFactory factory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {

        if (beanFactory instanceof ListableBeanFactory) {

            this.factory = (ListableBeanFactory)beanFactory;

            List<DefaultListener> defaultListenerList = sortListeners(this.factory, DefaultListener.class);
            setDefaultListeners(defaultListenerList);
            List<ChangeListener> changeListenerList = sortListeners(this.factory, ChangeListener.class);
            setChangeListeners(changeListenerList);
            List<ChangedListener> changedListenerList = sortListeners(this.factory, ChangedListener.class);
            setChangedListeners(changedListenerList);
            List<QueryListener> queryListenerList = sortListeners(this.factory, QueryListener.class);
            setQueryListeners(queryListenerList);
        }
    }


    private <S> List<S> sortListeners(ListableBeanFactory beanFactory, Class<S> clazz){
        List<S> result = new ArrayList<S>();
        Map<String, S> listenerMap = BeanFactoryUtils.beansOfTypeIncludingAncestors(beanFactory, clazz);
        for(S listener : listenerMap.values()){
            if(BaseService.class.isAssignableFrom(listener.getClass())){
                continue;
            }
            if(ORMUtils.isTheSameClass(getBaseClass(), listener.getClass())){
                result.add(listener);
            }
        }
        return result;
    }
}
