/*
 * Copyright 2017 @objectsql.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.objectsql.query;

import com.objectsql.support.*;

import java.util.Collection;
import java.util.List;

public interface Query extends IQuery {

	static Query newQuery(){
		return new QueryImpl();
	}
	static Query newQuery(String id){
		Query baseQuery = new QueryImpl();
		baseQuery.setId(id);
		return baseQuery;
	}

	//从class中获取字段，该字段可有可无
	Query table(Class<?> clazz);
	Query where(String name, ExpressionType type);
	<T,R> Query where(LambdaQuery<T,R> fieldFunction, ExpressionType type);

	Query whereEqual(String name, Object value);
	Query whereNotEqual(String name, Object value);
	<T,R> Query whereEqual(LambdaQuery<T,R> fieldFunction, Object value);
	<T,R> Query whereNotEqual(LambdaQuery<T,R> fieldFunction, Object value);

	Query whereLike(String name, String value);
	Query whereNotLike(String name, String value);
	Query whereStartWith(String name, String value);
	Query whereEndWith(String name, String value);
	Query whereNotStartWith(String name, String value);
	Query whereNotEndWith(String name, String value);

	<T,R> Query whereLike(LambdaQuery<T,R> fieldFunction, String value);
	<T,R> Query whereNotLike(LambdaQuery<T,R> fieldFunction, String value);
	<T,R> Query whereStartWith(LambdaQuery<T,R> fieldFunction, String value);
	<T,R> Query whereEndWith(LambdaQuery<T,R> fieldFunction, String value);
	<T,R> Query whereNotStartWith(LambdaQuery<T,R> fieldFunction, String value);
	<T,R> Query whereNotEndWith(LambdaQuery<T,R> fieldFunction, String value);

	Query whereLess(String name, Object value);
	Query whereLessEqual(String name, Object value);
	Query whereMore(String name, Object value);
	Query whereMoreEqual(String name, Object value);

	<T,R> Query whereLess(LambdaQuery<T,R> fieldFunction, Object value);
	<T,R> Query whereLessEqual(LambdaQuery<T,R> fieldFunction, Object value);
	<T,R> Query whereMore(LambdaQuery<T,R> fieldFunction, Object value);
	<T,R> Query whereMoreEqual(LambdaQuery<T,R> fieldFunction, Object value);

	Query whereIn(String name, Collection value);
	Query whereNotIn(String name, Collection value);
	Query whereInValues(String name, Object ... values);
	Query whereNotInValues(String name, Object ... values);

	<T,R> Query whereIn(LambdaQuery<T,R> fieldFunction, Collection value);
	<T,R> Query whereNotIn(LambdaQuery<T,R> fieldFunction, Collection value);
	<T,R> Query whereInValues(LambdaQuery<T,R> fieldFunction, Object ... values);
	<T,R> Query whereNotInValues(LambdaQuery<T,R> fieldFunction, Object ... values);

	Query whereIsNull(String name);
    Query whereIsNotNull(String name);
	Query whereIsEmpty(String name);
	Query whereIsNotEmpty(String name);
	Query where(String name, Object value, ExpressionType type);

	<T,R> Query whereIsNull(LambdaQuery<T,R> fieldFunction);
	<T,R> Query whereIsNotNull(LambdaQuery<T,R> fieldFunction);
	<T,R> Query whereIsEmpty(LambdaQuery<T,R> fieldFunction);
	<T,R> Query whereIsNotEmpty(LambdaQuery<T,R> fieldFunction);
	<T,R> Query where(LambdaQuery<T,R> fieldFunction, Object value, ExpressionType type);

	Query where(Condition condition);//select * from test where (a = ? or b = ? ...)

	Query where(Expression... expressions);

	Query whereBetween(String name, Object value, Object andValue);
	<T,R> Query whereBetween(LambdaQuery<T,R> fieldFunction, Object value, Object andValue);

	Query group(String name);
	Query groupCountSelectColumn(String name);
	Query having(String name, Object value, ExpressionType type);

	<T,R> Query group(LambdaQuery<T,R> fieldFunction);
	<T,R> Query groupCountSelectColumn(LambdaQuery<T,R> fieldFunction);
	<T,R> Query having(LambdaQuery<T,R> fieldFunction, Object value, ExpressionType type);

	Query having(Condition condition);//group by  having (a = ? or b = ? ...)

	Query orderDesc(String name);
	Query orderAsc(String name);
	<T,R> Query orderDesc(LambdaQuery<T,R> fieldFunction);
	<T,R> Query orderAsc(LambdaQuery<T,R> fieldFunction);

	Query order(Order order);
    Query orders(List<Order> orders);

	Query createQuery(String... names);
	Query createQuery(Class<?> clazz, String... names);

	<T,R> Query createQuery(LambdaQuery<T,R> ... names);
	<T,R> Query createQuery(Class<?> clazz, LambdaQuery<T,R> ... names);

	<T,R> Query createQuery(Select<T,R> select);
	<T,R> Query createQuery(Class<?> clazz, Select<T,R> select);

    Query createQuery(Class<?> clazz, Column... columns);
	Query addReturnColumn(Column ... columns);
	Query addReturnColumn(String ... columns);
	Query addReturnColumn(Columns ... columns);
	Query clearReturnColumns();
	Query addFixedReturnColumn(Column ... columns);
	Query addFixedReturnColumn(String ... columns);
	Query addFixedReturnColumn(Columns ... columns);
	Query clearFixedReturnColumns();

	<T,R> Query addReturnColumn(LambdaQuery<T,R> ... fieldFunctions);
	<T,R> Query addFixedReturnColumn(LambdaQuery<T,R> ... fieldFunctions);

	<T,R> Query addReturnColumn(Select<T,R> select);
	<T,R> Query addFixedReturnColumn(Select<T,R> select);


	Query distinct();

}
