package com.objectsql.query;

import com.objectsql.support.LambdaQuery;

import java.util.ArrayList;
import java.util.List;

public class Select<T, R> {

    final private List<LambdaQuery<T, R>> lambdaQueries = new ArrayList<>();

    public static <T, R> Select<T, R> of(LambdaQuery<T, R> query){
        return new Select<T, R>().and(query);
    }

    public Select<T,R> and(LambdaQuery<T, R> query){
        lambdaQueries.add(query);
        return this;
    }

    public List<LambdaQuery<T, R>> getLambdaQueries(){
        return lambdaQueries;
    }

    public int size(){
        return lambdaQueries.size();
    }
}
