package com.objectsql.spring;

import com.objectsql.handler.DebugHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LogHandler implements DebugHandler {

    private final Logger logger = LoggerFactory.getLogger(LogHandler.class);

    @Override
    public void handle(Class<?> clazz, String msg, Object... objects) {
        if (objects != null && objects.length > 0){
            if (objects.length > 1){
                List<Object> params = Arrays.stream(objects).collect(Collectors.toList());
                params.remove(0);
                Object last = params.get(params.size() - 1);
                if (last instanceof Throwable){
                    params.remove(last);
                }else{
                    last = null;
                }
                if (params.isEmpty()) {
                    LoggerFactory.getLogger(clazz).info("object-sql, method: {}. object: {}, other params: {}", msg, objects[0], params);
                }
                if (last != null){
                    LoggerFactory.getLogger(clazz).info("object-sql, exception method: " + msg, (Throwable)last);
                }
            }else{
                LoggerFactory.getLogger(clazz).info("object-sql, method: {}, object: {}", msg, objects[0]);
            }
        }else{
            LoggerFactory.getLogger(clazz).info("object-sql, method: {}", msg);
        }
    }
}
