package com.objectsql.spring;

import org.springframework.beans.TypeMismatchException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.validation.DataBinder;

import javax.sql.DataSource;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Connection;

public class SpringUtils {

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(clazz, annotationType);
    }

    public static Connection getConnection(DataSource dataSource) {
        return DataSourceUtils.getConnection(dataSource);
    }

    public static void releaseConnection(Connection con, DataSource dataSource) {
        DataSourceUtils.releaseConnection(con, dataSource);
    }

    public static <T> T convertIfNecessary(Field field, Object value) throws TypeMismatchException {
        DataBinder binder = new DataBinder(field, field.getName());
        return (T)binder.convertIfNecessary(value.toString(), field.getType());
    }
}