/*
 * Copyright 2017 @objectsql.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.objectsql.support;

import com.objectsql.listener.ServiceChangedListener;

public class PreChangeCache {

    private ServiceChangedListener changedListener;

    private ORMType ormType;
    private RowObject rowObject;

    public void changed(){
        changedListener.changed(ormType, rowObject);
    }

    public PreChangeCache(){}

    public PreChangeCache(ServiceChangedListener listener, ORMType ormType, RowObject rowObject){
        this.changedListener = listener;
        this.ormType = ormType;
        this.rowObject = rowObject;
    }

    public ServiceChangedListener getChangedListener() {
        return changedListener;
    }

    public void setChangedListener(ServiceChangedListener changedListener) {
        this.changedListener = changedListener;
    }

    public Object getOriginal() {
        if (this.getRowObject() != null){
            return this.getRowObject().getOriginal();
        }
        return null;
    }
    public Object getCurrent() {
        if (this.getRowObject() != null){
            return this.getRowObject().getCurrent();
        }
        return null;
    }


    public ORMType getOrmType() {
        return ormType;
    }

    public void setOrmType(ORMType ormType) {
        this.ormType = ormType;
    }

    public RowObject getRowObject() {
        return rowObject;
    }

    public void setRowObject(RowObject rowObject) {
        this.rowObject = rowObject;
    }
}
