/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.outerj.daisy.diff.html.HTMLDiffer;
import org.outerj.daisy.diff.html.HtmlSaxDiffOutput;
import org.outerj.daisy.diff.html.TextNodeComparator;
import org.outerj.daisy.diff.html.dom.DomTreeBuilder;
import org.outerj.daisy.diff.tag.TagComparator;
import org.outerj.daisy.diff.tag.TagDiffer;
import org.outerj.daisy.diff.tag.TagSaxDiffOutput;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class DaisyDiff {
    public static void diffHTML(InputSource oldSource, InputSource newSource, ContentHandler consumer, String prefix, Locale locale) throws SAXException, IOException {
        DomTreeBuilder oldHandler = new DomTreeBuilder();
        XMLReader xr1 = DaisyDiff.newXmlReader();
        xr1.setContentHandler(oldHandler);
        xr1.parse(oldSource);
        TextNodeComparator leftComparator = new TextNodeComparator(oldHandler, locale);
        DomTreeBuilder newHandler = new DomTreeBuilder();
        XMLReader xr2 = DaisyDiff.newXmlReader();
        xr2.setContentHandler(newHandler);
        xr2.parse(newSource);
        TextNodeComparator rightComparator = new TextNodeComparator(newHandler, locale);
        HtmlSaxDiffOutput output = new HtmlSaxDiffOutput(consumer, prefix);
        HTMLDiffer differ = new HTMLDiffer(output);
        differ.diff(leftComparator, rightComparator);
    }

    public static void diffTag(String oldText, String newText, ContentHandler consumer) throws Exception {
        consumer.startDocument();
        TagComparator oldComp = new TagComparator(oldText);
        TagComparator newComp = new TagComparator(newText);
        TagSaxDiffOutput output = new TagSaxDiffOutput(consumer);
        TagDiffer differ = new TagDiffer(output);
        differ.diff(oldComp, newComp);
        consumer.endDocument();
    }

    public static void diffTag(BufferedReader oldText, BufferedReader newText, ContentHandler consumer) throws Exception {
        TagComparator oldComp = new TagComparator(oldText);
        TagComparator newComp = new TagComparator(newText);
        TagSaxDiffOutput output = new TagSaxDiffOutput(consumer);
        TagDiffer differ = new TagDiffer(output);
        differ.diff(oldComp, newComp);
    }

    private static XMLReader newXmlReader() throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newDefaultInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            DaisyDiff.setFeatureQuietly(xmlReader, "http://apache.org/xml/features/disallow-doctype-decl", true);
            DaisyDiff.setFeatureQuietly(xmlReader, "http://xml.org/sax/features/external-general-entities", false);
            DaisyDiff.setFeatureQuietly(xmlReader, "http://xml.org/sax/features/external-parameter-entities", false);
            DaisyDiff.setFeatureQuietly(xmlReader, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return xmlReader;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("Failed to create secure XMLReader", e);
        }
    }

    private static void setFeatureQuietly(XMLReader xr, String feature, boolean value) {
        try {
            xr.setFeature(feature, value);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
    }
}

