/*
 * Decompiled with CFR 0.152.
 */
package com.opendevise.html5diff.helper;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMUtil {
    private DOMUtil() {
    }

    public static String getHTML(Node node) throws SAXException {
        Transformer transformer;
        DOMSource dom = new DOMSource(node);
        try {
            transformer = TransformerFactory.newDefaultInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e);
        }
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("method", "html");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        try {
            transformer.transform(dom, new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new SAXException(e);
        }
        Object html = writer.toString();
        if ("\r\n".equals(System.lineSeparator())) {
            html = ((String)html).replaceAll("\r\n", "\n");
        }
        if ("html".equals(node.getNodeName())) {
            html = "<!DOCTYPE html>" + (((String)(html = ((String)html).replaceFirst("<META [^>]+>", ""))).contains("<head>\n") ? "\n" : "") + (String)html;
        }
        return ((String)html).stripTrailing();
    }

    public static void emptyNode(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = childNodes.getLength() - 1; i >= 0; --i) {
            node.removeChild(childNodes.item(i));
        }
    }

    public static void moveChildren(Node from, Node to) {
        Node firstChild;
        while ((firstChild = from.getFirstChild()) != null) {
            to.appendChild(firstChild);
        }
    }
}

