/*
 * Decompiled with CFR 0.152.
 */
package com.opendevise.html5diff.cli;

import com.opendevise.html5diff.cli.StashCandidate;
import com.opendevise.html5diff.helper.DiffUtil;
import com.opendevise.html5diff.helper.HTMLUtil;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.Callable;
import org.xml.sax.InputSource;
import picocli.CommandLine;

@CommandLine.Command(name="html5diff", mixinStandardHelpOptions=true, version={"html5diff 1.0"}, description={"Creates a visual diff of pairs of HTML files and writes them to disk using the specified strategy."})
class HTML5DiffCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--format"}, negatable=true, defaultValue="true", fallbackValue="true", description={"Specifies whether to format the output HTML. (default: true)"})
    boolean format;
    @CommandLine.Option(names={"--indent"}, defaultValue="0", fallbackValue="0", description={"Specifies how many spaces to indent nested HTML tags when format is enabled. (default: 0)"})
    int indent;
    @CommandLine.Option(names={"--selector"}, defaultValue="body", fallbackValue="body", description={"Specifies the root tag to diff. The value can be a tag name (e.g., article) with an optional CSS class (e.g., article.doc) or an ID selector (e.g., #content). (default: body)"})
    String selector;
    @CommandLine.Option(names={"--output-file", "-o"}, paramLabel="<path>", description={"Specifies the file to which to write the HTML containing the visual diff."})
    String outPath;
    @CommandLine.Option(names={"--stash"}, paramLabel="<version>", description={"Specifies a version of the content to stash (changed or diff) in a sibling template tag. If not specified, nothing is stashed."})
    StashCandidate stash;
    @CommandLine.Parameters(paramLabel="OLD_FILE", index="0", description={"The path of the old file to compare with the new file."})
    String oldPath;
    @CommandLine.Parameters(paramLabel="NEW_FILE", index="1", description={"The path of the new file to compare with the old file."})
    String newPath;

    HTML5DiffCommand() {
    }

    @Override
    public Integer call() throws Exception {
        InputSource leftSource = new InputSource(new FileReader(this.oldPath));
        InputSource rightSource = new InputSource("-".equals(this.newPath) ? new InputStreamReader(System.in) : new FileReader(this.newPath));
        if (this.format && this.indent < 0) {
            String rightSourceString = HTML5DiffCommand.inputSourceToString(rightSource);
            this.indent = HTMLUtil.detectIndent(rightSourceString);
            rightSource = new InputSource(new StringReader(rightSourceString));
        }
        String stashVal = this.stash == null ? null : this.stash.value();
        String htmlWithDiffs = DiffUtil.diffHTML(leftSource, rightSource, this.selector, stashVal);
        if (this.format) {
            htmlWithDiffs = HTMLUtil.formatHTML(htmlWithDiffs, this.indent);
        }
        if ("-".equals(this.outPath) || this.outPath == null && "-".equals(this.newPath)) {
            System.out.print(htmlWithDiffs);
        } else {
            File toFile = new File(this.outPath == null ? this.newPath.replace(".html", ".diff.html") : this.outPath);
            Files.writeString(toFile.toPath(), (CharSequence)(htmlWithDiffs + "\n"), new OpenOption[0]);
        }
        return 0;
    }

    private static String inputSourceToString(InputSource inputSource) throws Exception {
        int length;
        Reader reader = inputSource.getCharacterStream();
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        while ((length = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, length);
        }
        return sb.toString();
    }

    public static void main(String ... args) {
        System.exit(HTML5DiffCommand.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        return new CommandLine((Object)new HTML5DiffCommand()).execute(args);
    }
}

