/*
 * Decompiled with CFR 0.152.
 */
package com.opendevise.html5diff.dom;

import com.opendevise.html5diff.dom.Selector;
import java.util.Objects;
import org.outerj.daisy.diff.html.dom.DomTreeBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SelectingDOMTreeBuilder
extends DomTreeBuilder {
    private final Selector selector;
    private final Document document;
    private Node currentElement;
    private Node selectedNode;
    private boolean selecting = false;
    private int selectingNodeDepth = 0;

    public SelectingDOMTreeBuilder(String selector) {
        this(Selector.parse(selector), null);
    }

    public SelectingDOMTreeBuilder(Selector selector) {
        this(selector, null);
    }

    public SelectingDOMTreeBuilder(String selector, Document document) {
        this(Selector.parse(selector), document);
    }

    public SelectingDOMTreeBuilder(Selector selector, Document document) {
        this.selector = selector;
        this.document = document;
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.document != null) {
            Element element = this.document.createElement(qName);
            int len = attributes.getLength();
            for (int i = 0; i < len; ++i) {
                element.setAttribute(attributes.getQName(i), attributes.getValue(i));
            }
            ((Node)Objects.requireNonNullElse(this.currentElement, this.document)).appendChild(element);
            this.currentElement = element;
        }
        if (!this.selecting) {
            this.selecting = this.selector.matches(localName, attributes.getValue("class"), attributes.getValue("id"));
            if (this.selecting) {
                if (this.document != null) {
                    this.selectedNode = this.currentElement;
                }
                this.bodyStarted = true;
                ++this.selectingNodeDepth;
            }
        } else {
            ++this.selectingNodeDepth;
            super.startElement(uri, localName, qName, attributes);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.document != null) {
            Node lastChild;
            if (this.selecting && this.selectingNodeDepth == 1 && (lastChild = this.currentElement.getLastChild()) != null && lastChild.getNodeType() == 3) {
                lastChild.setNodeValue(lastChild.getNodeValue().replaceFirst("\r?\n$", ""));
            }
            this.currentElement = this.currentElement.getParentNode();
        }
        if (!this.selecting) {
            return;
        }
        if (--this.selectingNodeDepth == 0) {
            this.selecting = false;
            this.bodyEnded = true;
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String text;
        if (this.document != null && !(text = new String(ch, start, length)).isEmpty()) {
            this.currentElement.appendChild(this.document.createTextNode(text));
        }
        if (this.selecting) {
            super.characters(ch, start, length);
        }
    }
}

