/*
 * Decompiled with CFR 0.152.
 */
package com.opendevise.html5diff.dom;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Selector {
    private final String tagName;
    private final String className;
    private final String id;

    Selector(String tagName, String className, String id) {
        this.tagName = tagName;
        this.className = className;
        this.id = id;
    }

    public boolean matches(String candidateTagName, String candidateClassName, String candidateId) {
        if (!"*".equals(this.tagName) && !candidateTagName.equals(this.tagName)) {
            return false;
        }
        if (this.className != null) {
            if (candidateClassName == null) {
                return false;
            }
            List<String> candidateClassNames = Arrays.asList(candidateClassName.split(" "));
            if (!candidateClassNames.contains(this.className)) {
                return false;
            }
        }
        if (this.id == null) {
            return true;
        }
        return candidateId != null && candidateId.equals(this.id);
    }

    public static Selector parse(String selector) {
        String tagName = selector;
        String className = null;
        String id = null;
        if (selector.startsWith("#")) {
            id = selector.substring(1);
            tagName = "";
        } else if (selector.contains(".")) {
            String[] segments = selector.split("[.]", 2);
            tagName = segments[0];
            className = segments[1];
        }
        return new Selector(tagName.isEmpty() ? "*" : tagName, className, id);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Selector otherSelector = (Selector)other;
        return Objects.equals(this.tagName, otherSelector.tagName) && Objects.equals(this.className, otherSelector.className) && Objects.equals(this.id, otherSelector.id);
    }

    public int hashCode() {
        return Objects.hash(this.tagName, this.className, this.id);
    }
}

