/*
 * Decompiled with CFR 0.152.
 */
package com.opendevise.html5diff.helper;

import com.opendevise.html5diff.dom.SelectingDOMTreeBuilder;
import com.opendevise.html5diff.dom.Selector;
import com.opendevise.html5diff.helper.DOMUtil;
import com.opendevise.html5diff.parsers.NekoHTMLParser;
import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.outerj.daisy.diff.html.HTMLDiffer;
import org.outerj.daisy.diff.html.HtmlSaxDiffOutput;
import org.outerj.daisy.diff.html.TextNodeComparator;
import org.outerj.daisy.diff.html.dom.DomTree;
import org.outerj.daisy.diff.output.DiffOutput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DiffUtil {
    private DiffUtil() {
    }

    public static String diffHTML(InputSource leftSource, InputSource rightSource, String selector) throws IOException, SAXException {
        return DiffUtil.diffHTML(leftSource, rightSource, selector, null);
    }

    public static String diffHTML(InputSource leftSource, InputSource rightSource, String selector, String stash) throws IOException, SAXException {
        TransformerHandler transformerHandler;
        Node targetNode;
        DocumentBuilder documentBuilder;
        Locale locale = Locale.getDefault();
        NekoHTMLParser parser = new NekoHTMLParser();
        Selector parsedSelector = Selector.parse(selector);
        SelectingDOMTreeBuilder leftHandler = new SelectingDOMTreeBuilder(parsedSelector);
        parser.parse(leftSource, (ContentHandler)((Object)leftHandler));
        TextNodeComparator leftComparator = new TextNodeComparator((DomTree)leftHandler, locale);
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        Document targetDocument = documentBuilder.newDocument();
        SelectingDOMTreeBuilder rightHandler = new SelectingDOMTreeBuilder(parsedSelector, targetDocument);
        parser.parse(rightSource, (ContentHandler)((Object)rightHandler));
        Node diffNode = targetNode = rightHandler.getSelectedNode();
        Element stashNode = null;
        if (stash != null) {
            stashNode = targetDocument.createElement("template");
            stashNode.setAttribute("class", "html5diff-stash");
            stashNode.setAttribute("data-selector", selector);
            targetNode.getParentNode().insertBefore(stashNode, targetNode.getNextSibling());
        }
        if ("diff".equals(stash)) {
            stashNode.setAttribute("data-view", "diff");
            diffNode = stashNode;
        } else if ("changed".equals(stash)) {
            stashNode.setAttribute("data-view", "changed");
            DOMUtil.moveChildren(targetNode, stashNode);
        } else {
            DOMUtil.emptyNode(targetNode);
        }
        TextNodeComparator rightComparator = new TextNodeComparator((DomTree)rightHandler, locale);
        try {
            transformerHandler = ((SAXTransformerFactory)SAXTransformerFactory.newInstance()).newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e);
        }
        transformerHandler.setResult(new DOMResult(diffNode));
        new HTMLDiffer((DiffOutput)new HtmlSaxDiffOutput((ContentHandler)transformerHandler, "diff")).diff(leftComparator, rightComparator);
        transformerHandler.comment(new char[0], 0, 0);
        diffNode.removeChild(diffNode.getLastChild());
        return DOMUtil.getHTML(targetDocument.getDocumentElement());
    }
}

