/*
 * Decompiled with CFR 0.152.
 */
package com.opendevise.html5diff.helper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;

public class HTMLUtil {
    private HTMLUtil() {
    }

    public static int detectIndent(String html) {
        Matcher m;
        Node previousNode;
        Element firstChildElement;
        int indent = 0;
        Document doc = Jsoup.parse((String)html);
        Element rootElement = html.contains("<html") ? doc.firstElementChild() : doc.body().firstElementChild();
        Element element = firstChildElement = rootElement == null ? null : rootElement.firstElementChild();
        if (firstChildElement != null && (previousNode = firstChildElement.previousSibling()) instanceof TextNode && (m = Pattern.compile("\r?\n( +)$").matcher(previousNode.nodeValue())).find()) {
            indent = m.group(1).length();
        }
        return indent;
    }

    public static String formatHTML(String html, int indent) {
        Parser parser = Parser.htmlParser();
        parser.settings(new ParseSettings(false, true));
        Document doc = Jsoup.parse((String)html, (Parser)parser);
        doc.outputSettings().indentAmount(indent);
        doc.outputSettings().charset("ascii");
        doc.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
        Object formattedHTML = doc.html();
        if (((String)formattedHTML).startsWith("<!doctype ")) {
            formattedHTML = "<!DOCTYPE " + ((String)formattedHTML).substring(10);
        }
        return formattedHTML;
    }
}

