/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.ICartridge;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.APIResource;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.Cartridge;
import com.openshift.internal.client.GearProfile;
import com.openshift.internal.client.ServiceParameter;
import com.openshift.internal.client.response.ApplicationResourceDTO;
import com.openshift.internal.client.response.DomainResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.LinkParameter;
import com.openshift.internal.client.response.Message;
import com.openshift.internal.client.utils.Assert;
import com.openshift.internal.client.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DomainResource
extends AbstractOpenShiftResource
implements IDomain {
    private static final String LINK_GET = "GET";
    private static final String LINK_LIST_APPLICATIONS = "LIST_APPLICATIONS";
    private static final String LINK_ADD_APPLICATION = "ADD_APPLICATION";
    private static final String LINK_UPDATE = "UPDATE";
    private static final String LINK_DELETE = "DELETE";
    private String id;
    private String suffix;
    private final APIResource connectionResource;
    private List<IApplication> applications = null;

    protected DomainResource(String namespace, String suffix, Map<String, Link> links, List<Message> creationLog, APIResource api) {
        super(api.getService(), links, creationLog);
        this.id = namespace;
        this.suffix = suffix;
        this.connectionResource = api;
    }

    protected DomainResource(DomainResourceDTO domainDTO, APIResource api) {
        this(domainDTO.getNamespace(), domainDTO.getSuffix(), domainDTO.getLinks(), domainDTO.getCreationLog(), api);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void rename(String id) throws OpenShiftException {
        Assert.notNull(id);
        DomainResourceDTO domainDTO = new UpdateDomainRequest().execute(id);
        this.id = domainDTO.getNamespace();
        this.suffix = domainDTO.getSuffix();
        this.getLinks().clear();
        this.getLinks().putAll(domainDTO.getLinks());
    }

    @Override
    public IUser getUser() throws OpenShiftException {
        return this.connectionResource.getUser();
    }

    @Override
    public boolean waitForAccessible(long timeout) throws OpenShiftException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IApplication createApplication(String name, ICartridge cartridge) throws OpenShiftException {
        return this.createApplication(name, cartridge, null, null);
    }

    @Override
    public IApplication createApplication(String name, ICartridge cartridge, ApplicationScale scale) throws OpenShiftException {
        return this.createApplication(name, cartridge, scale, null);
    }

    @Override
    public IApplication createApplication(String name, ICartridge cartridge, IGearProfile gearProfile) throws OpenShiftException {
        return this.createApplication(name, cartridge, null, gearProfile);
    }

    @Override
    public IApplication createApplication(String name, ICartridge cartridge, ApplicationScale scale, IGearProfile gearProfile) throws OpenShiftException {
        if (cartridge == null) {
            throw new OpenShiftException("Application type is mandatory but none was given.", new Object[0]);
        }
        if (name == null) {
            throw new OpenShiftException("Application name is mandatory but none was given.", new Object[0]);
        }
        if (this.hasApplicationByName(name)) {
            throw new OpenShiftException("Application with name \"{0}\" already exists.", name);
        }
        ApplicationResourceDTO applicationDTO = new CreateApplicationRequest().execute(name, cartridge.getName(), scale, gearProfile);
        ApplicationResource application = new ApplicationResource(applicationDTO, cartridge, this);
        this.applications.add(application);
        return application;
    }

    @Override
    public IApplication getApplicationByName(String name) throws OpenShiftException {
        Assert.notNull(name);
        IApplication matchingApplication = null;
        for (IApplication application : this.getApplications()) {
            if (!application.getName().equals(name)) continue;
            matchingApplication = application;
            break;
        }
        return matchingApplication;
    }

    @Override
    public boolean hasApplicationByName(String name) throws OpenShiftException {
        return this.getApplicationByName(name) != null;
    }

    @Override
    public List<IApplication> getApplicationsByCartridge(ICartridge cartridge) throws OpenShiftException {
        ArrayList<IApplication> matchingApplications = new ArrayList<IApplication>();
        for (IApplication application : this.getApplications()) {
            if (!cartridge.equals(application.getCartridge())) continue;
            matchingApplications.add(application);
        }
        return matchingApplications;
    }

    @Override
    public boolean hasApplicationByCartridge(ICartridge cartridge) throws OpenShiftException {
        return this.getApplicationsByCartridge(cartridge).size() > 0;
    }

    @Override
    public void destroy() throws OpenShiftException {
        this.destroy(false);
    }

    @Override
    public void destroy(boolean force) throws OpenShiftException {
        new DeleteDomainRequest().execute(force);
        this.connectionResource.removeDomain(this);
    }

    @Override
    public List<IApplication> getApplications() throws OpenShiftException {
        if (this.applications == null) {
            this.applications = this.loadApplications();
        }
        return CollectionUtils.toUnmodifiableCopy(this.applications);
    }

    private List<IApplication> loadApplications() throws OpenShiftException {
        ArrayList<IApplication> apps = new ArrayList<IApplication>();
        List applicationDTOs = (List)new ListApplicationsRequest().execute(new ServiceParameter[0]);
        for (ApplicationResourceDTO applicationDTO : applicationDTOs) {
            Cartridge cartridge = new Cartridge(applicationDTO.getFramework());
            ApplicationResource application = new ApplicationResource(applicationDTO, cartridge, this);
            apps.add(application);
        }
        return apps;
    }

    protected void removeApplication(IApplication application) {
        this.applications.remove(application);
    }

    @Override
    public List<String> getAvailableCartridgeNames() throws OpenShiftException {
        ArrayList<String> cartridges = new ArrayList<String>();
        for (LinkParameter param : this.getLink(LINK_ADD_APPLICATION).getRequiredParams()) {
            if (!param.getName().equals("cartridge")) continue;
            for (String option : param.getValidOptions()) {
                cartridges.add(option);
            }
        }
        return cartridges;
    }

    @Override
    public List<IGearProfile> getAvailableGearProfiles() throws OpenShiftException {
        ArrayList<IGearProfile> gearSizes = new ArrayList<IGearProfile>();
        for (LinkParameter param : this.getLink(LINK_ADD_APPLICATION).getOptionalParams()) {
            if (!param.getName().equals("gear_profile")) continue;
            for (String option : param.getValidOptions()) {
                gearSizes.add(new GearProfile(option));
            }
        }
        return gearSizes;
    }

    @Override
    public void refresh() throws OpenShiftException {
        DomainResourceDTO domainResourceDTO = new GetDomainRequest().execute();
        this.id = domainResourceDTO.getNamespace();
        this.suffix = domainResourceDTO.getSuffix();
        if (this.applications != null) {
            this.applications = this.loadApplications();
        }
    }

    public String toString() {
        return "Domain [id=" + this.id + ", " + "suffix = " + this.suffix + "]";
    }

    private class DeleteDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public DeleteDomainRequest() throws OpenShiftException {
            super(DomainResource.this, DomainResource.LINK_DELETE);
        }

        public void execute(boolean force) throws OpenShiftException {
            super.execute(new ServiceParameter("force", force));
        }
    }

    private class UpdateDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public UpdateDomainRequest() throws OpenShiftException {
            super(DomainResource.this, DomainResource.LINK_UPDATE);
        }

        public DomainResourceDTO execute(String namespace) throws OpenShiftException {
            return (DomainResourceDTO)super.execute(new ServiceParameter("id", namespace));
        }
    }

    private class CreateApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public CreateApplicationRequest() throws OpenShiftException {
            super(DomainResource.this, DomainResource.LINK_ADD_APPLICATION);
        }

        public ApplicationResourceDTO execute(String name, String cartridge, ApplicationScale scale, IGearProfile gearProfile) throws OpenShiftException {
            if (scale == null && gearProfile == null) {
                return this.execute(name, cartridge);
            }
            if (scale != null && gearProfile == null) {
                return this.execute(name, cartridge, scale);
            }
            if (scale == null && gearProfile != null) {
                return this.execute(name, cartridge, gearProfile);
            }
            return (ApplicationResourceDTO)super.execute(new ServiceParameter("name", name), new ServiceParameter("cartridge", cartridge), new ServiceParameter("scale", scale.getValue()), new ServiceParameter("gear_profile", gearProfile.getName()));
        }

        public ApplicationResourceDTO execute(String name, String cartridge, ApplicationScale scale) throws OpenShiftException {
            return (ApplicationResourceDTO)super.execute(new ServiceParameter("name", name), new ServiceParameter("cartridge", cartridge), new ServiceParameter("scale", scale.getValue()));
        }

        public ApplicationResourceDTO execute(String name, String cartridge, IGearProfile gearProfile) throws OpenShiftException {
            return (ApplicationResourceDTO)super.execute(new ServiceParameter("name", name), new ServiceParameter("cartridge", cartridge), new ServiceParameter("gear_profile", gearProfile.getName()));
        }

        public ApplicationResourceDTO execute(String name, String cartridge) throws OpenShiftException {
            return (ApplicationResourceDTO)super.execute(new ServiceParameter("name", name), new ServiceParameter("cartridge", cartridge));
        }
    }

    private class ListApplicationsRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public ListApplicationsRequest() throws OpenShiftException {
            super(DomainResource.this, DomainResource.LINK_LIST_APPLICATIONS);
        }
    }

    private class GetDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public GetDomainRequest() throws OpenShiftException {
            super(DomainResource.this, DomainResource.LINK_GET);
        }

        protected DomainResourceDTO execute() throws OpenShiftException {
            return (DomainResourceDTO)super.execute(new ServiceParameter[0]);
        }
    }
}

