/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.response.Message;
import com.openshift.internal.client.response.ResourceDTOFactory;
import com.openshift.internal.client.response.RestResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftEndpointException
extends OpenShiftException {
    private static final long serialVersionUID = 8251533839480636815L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenShiftEndpointException.class);
    private final String url;
    private final String response;

    public OpenShiftEndpointException(String url, Throwable cause, String response, String message, Object ... arguments) {
        super(cause, message, arguments);
        this.response = response;
        this.url = url;
    }

    public RestResponse getRestResponse() throws OpenShiftException {
        if (this.response == null) {
            return null;
        }
        return ResourceDTOFactory.get(this.response);
    }

    public List<Message> getRestResponseMessages() {
        if (this.response == null) {
            return null;
        }
        try {
            return ResourceDTOFactory.get(this.response).getMessages();
        }
        catch (OpenShiftException e) {
            LOGGER.error("Unable to parse the response", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Unable to parse the response", (Throwable)e);
        }
        return null;
    }

    protected String getUrl() {
        return this.url;
    }
}

