/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IOpenShiftResource;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftRequestException;
import com.openshift.internal.client.IRestService;
import com.openshift.internal.client.ServiceParameter;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.Message;
import com.openshift.internal.client.response.RestResponse;
import java.util.List;
import java.util.Map;

public abstract class AbstractOpenShiftResource
implements IOpenShiftResource {
    private Map<String, Link> links;
    private final IRestService service;
    private List<Message> creationLog;

    public AbstractOpenShiftResource(IRestService service) {
        this(service, null, null);
    }

    public AbstractOpenShiftResource(IRestService service, Map<String, Link> links, List<Message> creationLog) {
        this.service = service;
        this.links = links;
        this.creationLog = creationLog;
    }

    Map<String, Link> getLinks() throws OpenShiftException {
        return this.links;
    }

    void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    protected final IRestService getService() {
        return this.service;
    }

    protected Link getLink(String linkName) throws OpenShiftException {
        Link link = null;
        if (this.getLinks() != null) {
            link = this.getLinks().get(linkName);
        }
        if (link == null) {
            throw new OpenShiftRequestException("Could not find link \"{0}\" in resource \"{1}\"", linkName, this.getClass().getSimpleName());
        }
        return link;
    }

    protected boolean areLinksLoaded() {
        return this.links != null;
    }

    @Override
    public String getCreationLog() {
        if (!this.hasCreationLog()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Message message : this.creationLog) {
            builder.append(message.getText());
        }
        return builder.toString();
    }

    @Override
    public boolean hasCreationLog() {
        return this.creationLog != null && this.creationLog.size() > 0;
    }

    protected class ServiceRequest {
        private String linkName;

        protected ServiceRequest(String linkName) {
            this.linkName = linkName;
        }

        protected <DTO> DTO execute(ServiceParameter ... parameters) throws OpenShiftException {
            Link link = AbstractOpenShiftResource.this.getLink(this.linkName);
            RestResponse response = AbstractOpenShiftResource.this.getService().request(link, parameters);
            if (response == null) {
                return null;
            }
            return (DTO)response.getData();
        }

        protected String execute(String addOn, ServiceParameter ... parameters) throws OpenShiftException {
            try {
                Link link = AbstractOpenShiftResource.this.getLink(this.linkName);
                link = new Link(link.getRel(), link.getHref() + "/" + addOn, link.getHttpMethod(), link.getRequiredParams(), link.getOptionalParams());
                String response = AbstractOpenShiftResource.this.getService().request(link, "application/xml", parameters);
                return response;
            }
            catch (Exception e) {
                throw new OpenShiftException(e, "Unable to execute request", new Object[0]);
            }
        }
    }
}

