/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IEmbeddableCartridge;
import com.openshift.internal.client.AbstractCartridgeConstraint;
import com.openshift.internal.client.utils.Assert;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LatestVersionOfName
extends AbstractCartridgeConstraint {
    private final String nameConstraint;

    public LatestVersionOfName(String name) {
        Assert.isTrue(name != null);
        this.nameConstraint = name;
    }

    public String getNameConstraint() {
        return this.nameConstraint;
    }

    @Override
    public <C extends IEmbeddableCartridge> Collection<C> getMatching(Collection<C> cartridges) {
        C latest = this.getLatest(new ArrayList<C>(super.getMatching(cartridges)));
        if (latest == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(latest);
    }

    @Override
    public <C extends IEmbeddableCartridge> boolean matches(C cartridge) {
        return cartridge.getName().startsWith(this.nameConstraint);
    }

    protected <C extends IEmbeddableCartridge> C getLatest(List<C> matchingCartridges) {
        if (matchingCartridges.size() == 0) {
            return null;
        }
        if (matchingCartridges.size() == 1) {
            return (C)((IEmbeddableCartridge)matchingCartridges.get(0));
        }
        Collections.sort(matchingCartridges, new Comparator<C>(){

            @Override
            public int compare(C thisCartridge, C thatCartridge) {
                VersionedName thisName = new VersionedName(thisCartridge.getName());
                VersionedName thatName = new VersionedName(thatCartridge.getName());
                return thisName.compareTo(thatName);
            }
        });
        return (C)((IEmbeddableCartridge)matchingCartridges.get(matchingCartridges.size() - 1));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nameConstraint == null ? 0 : this.nameConstraint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LatestVersionOfName)) {
            return false;
        }
        LatestVersionOfName other = (LatestVersionOfName)obj;
        return !(this.nameConstraint == null ? other.nameConstraint != null : !this.nameConstraint.equals(other.nameConstraint));
    }

    protected class VersionedName
    implements Comparable<VersionedName> {
        private Pattern versionPattern = Pattern.compile("([^-]+)-([0-9a-zA-Z]+)\\.{0,1}([0-9a-zA-Z]*)");
        private Collator collator = Collator.getInstance();
        private String name;
        private String major;
        private String minor;

        protected VersionedName(String name) {
            Matcher matcher = this.versionPattern.matcher(name);
            if (!matcher.matches()) {
                this.name = name;
            }
            this.name = matcher.group(1);
            if (matcher.groupCount() >= 2) {
                this.major = matcher.group(2);
                if (matcher.groupCount() >= 3) {
                    this.minor = matcher.group(3);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean hasVersion() {
            return this.major != null;
        }

        public String getMajor() {
            return this.major;
        }

        public String getMinor() {
            return this.minor;
        }

        @Override
        public int compareTo(VersionedName other) {
            int result = this.collator.compare(this.getName(), other.getName());
            if (result != 0) {
                return result;
            }
            result = this.collator.compare(this.major, other.getMajor());
            if (result != 0) {
                return result;
            }
            return this.collator.compare(this.minor, other.getMinor());
        }
    }
}

