/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.openshift.client.OpenShiftException;
import java.util.Arrays;
import java.util.List;

public class DeploymentTypes {
    private static final String GIT = "git";
    private static final String BINARY = "binary";

    private DeploymentTypes() {
    }

    public static String git() {
        return GIT;
    }

    public static String binary() {
        return BINARY;
    }

    public static boolean isBinary(String deploymentType) {
        return BINARY.equals(deploymentType);
    }

    public static boolean isGit(String deploymentType) {
        return GIT.equals(deploymentType);
    }

    public static List<String> getAll() {
        return Arrays.asList(GIT, BINARY);
    }

    public static String switchType(String deploymentType) {
        if (DeploymentTypes.isBinary(deploymentType)) {
            return GIT;
        }
        if (DeploymentTypes.isGit(deploymentType)) {
            return BINARY;
        }
        throw new OpenShiftException("Unknown deployment type {0}", deploymentType);
    }
}

