/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IQuickstart;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.query.ICartridgeQuery;
import com.openshift.internal.client.APIResource;
import com.openshift.internal.client.AlternativeCartridges;
import com.openshift.internal.client.response.QuickstartDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Quickstart
implements IQuickstart {
    private final String id;
    private final String href;
    private final String name;
    private final String summary;
    private final List<AlternativeCartridges> alternativeCartridges;
    private final String website;
    private final List<String> tags;
    private final String language;
    private final String initialGitUrl;
    private final String provider;

    Quickstart(QuickstartDTO dto, APIResource api) {
        this.id = dto.getId();
        this.href = dto.getHref();
        this.name = dto.getName();
        this.summary = dto.getSummary();
        this.alternativeCartridges = this.createAlternativeCartridges(dto.getCartridges(), api);
        this.website = dto.getWebsite();
        this.tags = dto.getTags();
        this.language = dto.getLanguage();
        this.initialGitUrl = dto.getInitialGitUrl();
        this.provider = dto.getProvider();
    }

    private List<AlternativeCartridges> createAlternativeCartridges(List<ICartridgeQuery> cartridges, APIResource api) {
        ArrayList<AlternativeCartridges> alternativeCartridges = new ArrayList<AlternativeCartridges>();
        if (cartridges != null) {
            for (ICartridgeQuery query : cartridges) {
                alternativeCartridges.add(new AlternativeCartridges(query, api));
            }
        }
        return alternativeCartridges;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public List<AlternativeCartridges> getSuitableCartridges() {
        return Collections.unmodifiableList(this.alternativeCartridges);
    }

    @Override
    public List<ICartridge> getAlternativesFor(ICartridge cartridge) {
        if (cartridge != null) {
            for (AlternativeCartridges alternatives : this.alternativeCartridges) {
                if (!alternatives.get().contains(cartridge)) continue;
                return alternatives.get();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String getWebsite() {
        return this.website;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getInitialGitUrl() {
        return this.initialGitUrl;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alternativeCartridges == null ? 0 : this.alternativeCartridges.hashCode());
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.initialGitUrl == null ? 0 : this.initialGitUrl.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.provider == null ? 0 : this.provider.hashCode());
        result = 31 * result + (this.summary == null ? 0 : this.summary.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.website == null ? 0 : this.website.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quickstart other = (Quickstart)obj;
        if (this.alternativeCartridges == null ? other.alternativeCartridges != null : !this.alternativeCartridges.equals(other.alternativeCartridges)) {
            return false;
        }
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.initialGitUrl == null ? other.initialGitUrl != null : !this.initialGitUrl.equals(other.initialGitUrl)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.provider == null ? other.provider != null : !this.provider.equals(other.provider)) {
            return false;
        }
        if (this.summary == null ? other.summary != null : !this.summary.equals(other.summary)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return !(this.website == null ? other.website != null : !this.website.equals(other.website));
    }

    public String toString() {
        return "Quickstart [id=" + this.id + ", href=" + this.href + ", name=" + this.name + ", summary=" + this.summary + ", cartridges=" + this.alternativeCartridges + ", website=" + this.website + ", tags=" + this.tags + ", language=" + this.language + ", initialGitUrl=" + this.initialGitUrl + ", provider=" + this.provider + "]";
    }
}

