/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.response;

import com.openshift.client.IField;
import com.openshift.client.Message;
import com.openshift.client.Messages;
import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.response.EnumDataType;
import com.openshift.internal.client.response.IRestResponseFactory;
import com.openshift.internal.client.response.RestResponse;
import com.openshift.internal.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonDTOFactory
implements IRestResponseFactory {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractJsonDTOFactory.class);

    @Override
    public RestResponse get(String json) throws OpenShiftException {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        this.LOGGER.trace("Unmarshalling response\n{}", (Object)json);
        ModelNode rootNode = this.getModelNode(json);
        String type = this.getAsString(rootNode, "type");
        String status = this.getAsString(rootNode, "status");
        Messages messages = this.createMessages(rootNode.get("messages"));
        EnumDataType dataType = EnumDataType.safeValueOf(type);
        ModelNode dataNode = rootNode.get("data");
        Object data = null;
        if (dataNode.isDefined()) {
            data = this.createData(dataType, messages, rootNode.get("data"));
        }
        return new RestResponse(status, messages, data, dataType);
    }

    protected abstract Object createData(EnumDataType var1, Messages var2, ModelNode var3);

    private Messages createMessages(ModelNode messagesNode) {
        LinkedHashMap<IField, List<Message>> messagesByField = new LinkedHashMap<IField, List<Message>>();
        if (messagesNode.getType() == ModelType.LIST) {
            for (ModelNode messageNode : messagesNode.asList()) {
                Message message = this.createMessage(messageNode);
                ArrayList<Message> messages = (ArrayList<Message>)messagesByField.get(message.getField());
                if (messages == null) {
                    messages = new ArrayList<Message>();
                }
                messages.add(message);
                messagesByField.put(message.getField(), messages);
            }
        }
        return new Messages(messagesByField);
    }

    private Message createMessage(ModelNode messageNode) {
        String text = this.getAsString(messageNode, "text");
        String field = this.getAsString(messageNode, "field");
        int exitCode = this.getAsInteger(messageNode, "exit_code");
        String severity = this.getAsString(messageNode, "severity");
        return new Message(text, field, severity, exitCode);
    }

    protected ModelNode getModelNode(String content) throws OpenShiftException {
        if (content == null) {
            throw new OpenShiftException("Could not unmarshall response: no content.", new Object[0]);
        }
        ModelNode node = ModelNode.fromJSONString((String)content);
        if (!node.isDefined()) {
            throw new OpenShiftException("Could not unmarshall response: erroneous content.", new Object[0]);
        }
        return node;
    }

    protected String getAsString(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? propertyNode.asString() : null;
    }

    protected Boolean getAsBoolean(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? propertyNode.asBoolean() : Boolean.FALSE.booleanValue();
    }

    protected int getAsInteger(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? propertyNode.asInt() : -1;
    }

    protected boolean isDefined(ModelNode node) {
        return node != null && node.isDefined();
    }
}

