/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.cartridge;

import com.openshift.client.cartridge.ICartridge;
import com.openshift.internal.client.CartridgeType;
import com.openshift.internal.client.utils.StringUtils;
import java.net.URL;

public class BaseCartridge
implements ICartridge {
    private final String name;
    private String displayName;
    private String description;
    private URL url;
    private boolean obsolete;

    public BaseCartridge(String name) {
        this(name, null, null, null);
    }

    public BaseCartridge(URL url) {
        this(null, url, null, null);
    }

    protected BaseCartridge(String name, URL url) {
        this(name, url, null, null);
    }

    protected BaseCartridge(String name, String displayName, String description, boolean obsolete) {
        this(name, null, displayName, description, obsolete);
    }

    protected BaseCartridge(String name, URL url, String displayName, String description) {
        this(name, url, displayName, description, false);
    }

    protected BaseCartridge(String name, URL url, String displayName, String description, boolean obsolete) {
        this.url = url;
        this.name = name;
        this.displayName = this.getDisplayName(displayName, url);
        this.description = description;
        this.obsolete = obsolete;
    }

    protected String getDisplayName(String displayName, URL url) {
        if (!StringUtils.isEmpty(displayName)) {
            return displayName;
        }
        if (url != null) {
            return url.getRef();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDownloadable() {
        return this.url != null;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public CartridgeType getType() {
        return CartridgeType.UNDEFINED;
    }

    @Override
    public boolean isObsolete() {
        return this.obsolete;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseCartridge)) {
            return false;
        }
        BaseCartridge other = (BaseCartridge)obj;
        if (this.isDownloadable() && other.isDownloadable()) {
            if (this.getUrl() == null) {
                return other.getUrl() == null;
            }
            return this.getUrl().equals(other.getUrl());
        }
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ " + "name=" + this.name + ", url=" + this.url + ", displayName = " + this.displayName + ", description=" + this.description + ", obsolete=" + this.obsolete + " ]";
    }
}

