/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> List<T> toUnmodifiableCopy(Collection<T> collection) {
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    public static <T> List<T> toList(T element, T ... elements) {
        ArrayList<T> allElements = new ArrayList<T>();
        if (element != null) {
            allElements.add(element);
        }
        if (elements != null) {
            Collections.addAll(allElements, elements);
        }
        return allElements;
    }
}

