/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import com.openshift.internal.client.utils.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class ApplicationBuilder {
    private IDomain domain;

    public ApplicationBuilder(IDomain domain) {
        this.domain = domain;
    }

    public NamedBuilder setName(String name) {
        return new NamedBuilder(name);
    }

    public class NamedUnTypedCartridgeBuilder
    extends AbstractNamedCartridgeBuilder<NamedUnTypedCartridgeBuilder> {
        private Collection<ICartridge> cartridges;

        NamedUnTypedCartridgeBuilder(String name, Collection<ICartridge> cartridges) {
            super(name);
            this.cartridges = cartridges;
        }

        public IApplication build() {
            return ApplicationBuilder.this.domain.createApplication(this.name, this.applicationScale, this.gearProfile, this.initialGitUrl, this.timeout, this.environmentVariables, this.cartridges.toArray(new ICartridge[this.cartridges.size()]));
        }
    }

    public class NamedTypedCartridgeBuilder
    extends AbstractNamedCartridgeBuilder<NamedTypedCartridgeBuilder> {
        private IStandaloneCartridge standaloneCartridge;
        private Collection<IEmbeddableCartridge> embeddableCartridges;

        NamedTypedCartridgeBuilder(String name, IStandaloneCartridge standaloneCartridge) {
            super(name);
            this.standaloneCartridge = standaloneCartridge;
        }

        public NamedTypedCartridgeBuilder setEmbeddableCartridges(IEmbeddableCartridge ... embeddableCartridges) {
            if (embeddableCartridges == null) {
                return this;
            }
            this.embeddableCartridges = Arrays.asList(embeddableCartridges);
            return this;
        }

        public IApplication build() {
            return ApplicationBuilder.this.domain.createApplication(this.name, this.applicationScale, this.gearProfile, this.initialGitUrl, this.timeout, this.environmentVariables, this.createCartridges(this.standaloneCartridge, this.embeddableCartridges));
        }

        protected ICartridge[] createCartridges(IStandaloneCartridge standaloneCartridge, Collection<? extends ICartridge> embeddableCartridges) {
            ArrayList<? extends ICartridge> cartridges = new ArrayList<ICartridge>();
            cartridges.add(standaloneCartridge);
            if (embeddableCartridges != null && !embeddableCartridges.isEmpty()) {
                cartridges.addAll(embeddableCartridges);
            }
            return cartridges.toArray(new ICartridge[cartridges.size()]);
        }
    }

    protected abstract class AbstractNamedCartridgeBuilder<B> {
        protected String name;
        protected IGearProfile gearProfile;
        protected ApplicationScale applicationScale;
        protected String initialGitUrl;
        protected int timeout = -1;
        protected Map<String, String> environmentVariables;

        AbstractNamedCartridgeBuilder(String name) {
            this.name = name;
        }

        public B setGearProfile(IGearProfile gearProfile) {
            this.gearProfile = gearProfile;
            return (B)this;
        }

        public B setApplicationScale(ApplicationScale applicationScale) {
            this.applicationScale = applicationScale;
            return (B)this;
        }

        public B setInitialGitUrl(String initialGitUrl) {
            this.initialGitUrl = initialGitUrl;
            return (B)this;
        }

        public B setTimeout(int timeout) {
            this.timeout = timeout;
            return (B)this;
        }

        public B setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return (B)this;
        }
    }

    public class NamedBuilder {
        private String name;

        protected NamedBuilder(String name) {
            this.name = name;
        }

        public NamedTypedCartridgeBuilder setStandaloneCartridge(IStandaloneCartridge standaloneCartridge) {
            return new NamedTypedCartridgeBuilder(this.name, standaloneCartridge);
        }

        public NamedUnTypedCartridgeBuilder setCartridges(Collection<ICartridge> cartridges) {
            Assert.isTrue(cartridges != null && !cartridges.isEmpty());
            return new NamedUnTypedCartridgeBuilder(this.name, cartridges);
        }
    }
}

