/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client.cartridge.query;

import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.query.AbstractCartridgeQuery;
import com.openshift.internal.client.utils.Assert;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LatestVersionQuery
extends AbstractCartridgeQuery {
    private final String nameConstraint;

    public LatestVersionQuery(String name) {
        Assert.isTrue(name != null);
        this.nameConstraint = name;
    }

    public String getNameConstraint() {
        return this.nameConstraint;
    }

    @Override
    public <C extends ICartridge> List<C> getAll(List<C> cartridges) {
        return Collections.singletonList(this.getLatest(super.getAll(cartridges)));
    }

    @Override
    public <C extends ICartridge> C get(List<C> cartridges) {
        return this.getLatest(super.getAll(cartridges));
    }

    @Override
    public <C extends ICartridge> boolean matches(C cartridge) {
        String name = cartridge.getName();
        int delimiterIndex = name.lastIndexOf(45);
        if (delimiterIndex == -1) {
            return false;
        }
        return this.nameConstraint.equals(name.substring(0, delimiterIndex));
    }

    protected <C extends ICartridge> C getLatest(Collection<C> matchingCartridges) {
        Iterator<C> it = matchingCartridges.iterator();
        if (!it.hasNext()) {
            return null;
        }
        ICartridge latest = (ICartridge)it.next();
        while (it.hasNext()) {
            ICartridge cartridge = (ICartridge)it.next();
            VersionedName latestName = new VersionedName(latest.getName());
            VersionedName cartridgeName = new VersionedName(cartridge.getName());
            switch (latestName.compareTo(cartridgeName)) {
                case 0: 
                case 1: {
                    break;
                }
                case -1: {
                    latest = cartridge;
                }
            }
        }
        return (C)latest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nameConstraint == null ? 0 : this.nameConstraint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LatestVersionQuery)) {
            return false;
        }
        LatestVersionQuery other = (LatestVersionQuery)obj;
        return !(this.nameConstraint == null ? other.nameConstraint != null : !this.nameConstraint.equals(other.nameConstraint));
    }

    protected class VersionedName
    implements Comparable<VersionedName> {
        private Pattern versionPattern = Pattern.compile("(([^- ]+-)*([^-]+))-([0-9a-zA-Z]+)\\.{0,1}([0-9a-zA-Z]*)");
        private Collator collator = Collator.getInstance();
        private String name;
        private String major;
        private String minor;

        protected VersionedName(String name) {
            Matcher matcher = this.versionPattern.matcher(name);
            if (!matcher.matches()) {
                this.name = name;
                return;
            }
            this.name = matcher.group(1);
            if (matcher.groupCount() >= 4) {
                this.major = matcher.group(4);
                if (matcher.groupCount() >= 5) {
                    this.minor = matcher.group(5);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean hasVersion() {
            return this.major != null;
        }

        public String getMajor() {
            return this.major;
        }

        public String getMinor() {
            return this.minor;
        }

        @Override
        public int compareTo(VersionedName other) {
            int result = this.collator.compare(this.getName(), other.getName());
            if (result != 0) {
                return result;
            }
            result = this.collator.compare(this.major, other.getMajor());
            if (result != 0) {
                return result;
            }
            return this.collator.compare(this.minor, other.getMinor());
        }
    }
}

