/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.GearState;
import com.openshift.client.IGear;
import com.openshift.client.IGearGroup;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.Gear;
import com.openshift.internal.client.IRestService;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.GearGroupResourceDTO;
import com.openshift.internal.client.response.GearResourceDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class GearGroupResource
extends AbstractOpenShiftResource
implements IGearGroup {
    private final String uuid;
    private final String name;
    private final Collection<IGear> gears;
    private final int additionalStorage;
    private final Collection<ICartridge> cartridges;

    protected GearGroupResource(String uuid, String name, Collection<GearResourceDTO> gearDTOs, Map<String, CartridgeResourceDTO> cartridgeDTOs, int additionalStorage, ApplicationResource application, IRestService service) {
        super(service);
        this.uuid = uuid;
        this.name = name;
        this.gears = new ArrayList<IGear>();
        this.additionalStorage = additionalStorage;
        for (GearResourceDTO dto : gearDTOs) {
            this.gears.add(new Gear(dto.getUuid(), new GearState(dto.getState()), dto.getSshUrl()));
        }
        this.cartridges = new ArrayList<ICartridge>();
        Iterator<Map.Entry<String, CartridgeResourceDTO>> iterator = cartridgeDTOs.entrySet().iterator();
        while (iterator.hasNext()) {
            String cartridgeName = iterator.next().getKey();
            ICartridge cartridge = application.getCartridge(cartridgeName);
            if (cartridge == null) continue;
            this.cartridges.add(cartridge);
        }
    }

    protected GearGroupResource(GearGroupResourceDTO dto, ApplicationResource application, IRestService service) {
        this(dto.getUuid(), dto.getName(), dto.getGears(), dto.getCartridges(), dto.getAdditionalStorage(), application, service);
    }

    @Override
    public final String getUUID() {
        return this.uuid;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Collection<IGear> getGears() {
        return Collections.unmodifiableCollection(this.gears);
    }

    @Override
    public int getAdditionalStorage() {
        return this.additionalStorage;
    }

    @Override
    public Collection<ICartridge> getCartridges() {
        return this.cartridges;
    }

    @Override
    public void refresh() throws OpenShiftException {
    }
}

