/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IAuthorization;
import com.openshift.client.IDomain;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.ISSHPublicKey;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftSSHKeyException;
import com.openshift.client.OpenShiftUnknonwSSHKeyTypeException;
import com.openshift.client.SSHKeyType;
import com.openshift.internal.client.APIResource;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.DomainResource;
import com.openshift.internal.client.SSHKeyResource;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.StringParameter;
import com.openshift.internal.client.response.KeyResourceDTO;
import com.openshift.internal.client.response.UserResourceDTO;
import com.openshift.internal.client.utils.Assert;
import com.openshift.internal.client.utils.CollectionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserResource
extends AbstractOpenShiftResource
implements IUser {
    private final APIResource api;
    private final String id;
    private final String rhLogin;
    private final String password;
    private final int maxGears;
    private final int consumedGears;
    private Map<String, SSHKeyResource> sshKeys;

    public UserResource(APIResource api, UserResourceDTO dto, String password) {
        super(api.getService(), dto.getLinks(), dto.getMessages());
        this.api = api;
        this.id = dto.getId();
        this.rhLogin = dto.getRhLogin();
        this.maxGears = dto.getMaxGears();
        this.consumedGears = dto.getConsumedGears();
        this.password = password;
    }

    @Override
    public IOpenShiftConnection getConnection() {
        return this.api;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRhlogin() {
        return this.rhLogin;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getServer() {
        return this.api.getServer();
    }

    @Override
    public int getMaxGears() {
        return this.maxGears;
    }

    @Override
    public int getConsumedGears() {
        return this.consumedGears;
    }

    @Override
    public IDomain createDomain(String id) throws OpenShiftException {
        Assert.notNull(id);
        return this.api.createDomain(id);
    }

    @Override
    public List<IDomain> getDomains() throws OpenShiftException {
        List<IDomain> domains = this.api.getDomains();
        return domains;
    }

    @Override
    public IDomain getDefaultDomain() throws OpenShiftException {
        return this.api.getDefaultDomain();
    }

    @Override
    public IDomain getDomain(String id) throws OpenShiftException {
        return this.api.getDomain(id);
    }

    @Override
    public boolean hasDomain() throws OpenShiftException {
        return this.api.getDomains().size() > 0;
    }

    @Override
    public boolean hasDomain(String id) throws OpenShiftException {
        Assert.notNull(id);
        return this.api.getDomain(id) != null;
    }

    @Override
    public IAuthorization createAuthorization(String note, String scopes) throws OpenShiftException {
        return this.api.createAuthorization(note, scopes);
    }

    @Override
    public IAuthorization createAuthorization(String note, String scopes, int expiresIn) throws OpenShiftException {
        return this.api.createAuthorization(note, scopes, expiresIn);
    }

    @Override
    public IAuthorization getAuthorization() throws OpenShiftException {
        return this.api.getAuthorization();
    }

    @Override
    public IAuthorization getAuthorization(String id) throws OpenShiftException {
        Assert.notNull(id);
        return this.api.getAuthorization(id);
    }

    @Override
    public Collection<IAuthorization> getAuthorizations() throws OpenShiftException {
        return this.api.getAuthorizations();
    }

    @Override
    public boolean removeAuthorization(String id) {
        Assert.notNull(id);
        IAuthorization auth = this.getAuthorization(id);
        if (auth == null) {
            return false;
        }
        auth.destroy();
        this.api.removeAuthorization();
        this.api.refresh();
        return true;
    }

    @Override
    public void refresh() throws OpenShiftException {
        this.sshKeys = this.loadKeys();
        this.api.refresh();
        DomainResource defaultDomain = (DomainResource)this.getDefaultDomain();
        if (defaultDomain != null) {
            defaultDomain.refresh();
        }
    }

    @Override
    public List<IOpenShiftSSHKey> getSSHKeys() throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        HashMap<String, SSHKeyResource> keys = new HashMap<String, SSHKeyResource>();
        keys.putAll(this.getCachedOrLoadSSHKeys());
        return CollectionUtils.toUnmodifiableCopy(keys.values());
    }

    private Map<String, SSHKeyResource> getCachedOrLoadSSHKeys() throws OpenShiftException, OpenShiftUnknonwSSHKeyTypeException {
        if (this.sshKeys == null) {
            this.sshKeys = this.loadKeys();
        }
        return this.sshKeys;
    }

    private Map<String, SSHKeyResource> loadKeys() throws OpenShiftException, OpenShiftUnknonwSSHKeyTypeException {
        HashMap<String, SSHKeyResource> keys = new HashMap<String, SSHKeyResource>();
        List<KeyResourceDTO> keyDTOs = new GetSShKeysRequest().execute();
        for (KeyResourceDTO keyDTO : keyDTOs) {
            keys.put(keyDTO.getName(), new SSHKeyResource(keyDTO, this));
        }
        return keys;
    }

    @Override
    public boolean removeSSHKey(String name) {
        IOpenShiftSSHKey key = this.getSSHKeyByName(name);
        if (key == null) {
            return false;
        }
        key.destroy();
        this.getCachedOrLoadSSHKeys().remove(name);
        return true;
    }

    @Override
    @Deprecated
    public void deleteKey(String name) {
        this.removeSSHKey(name);
    }

    @Override
    public IOpenShiftSSHKey getSSHKeyByName(String name) throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        Assert.notNull(name);
        return this.getCachedOrLoadSSHKeys().get(name);
    }

    @Override
    public IOpenShiftSSHKey getSSHKeyByPublicKey(String publicKey) throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        Assert.notNull(publicKey);
        SSHKeyResource matchingKey = null;
        if (publicKey == null) {
            return null;
        }
        for (SSHKeyResource key : this.getCachedOrLoadSSHKeys().values()) {
            if (!publicKey.equals(key.getPublicKey())) continue;
            matchingKey = key;
            break;
        }
        return matchingKey;
    }

    @Override
    public boolean hasSSHKeyName(String name) throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        Assert.notNull(name);
        return this.getSSHKeyByName(name) != null;
    }

    @Override
    public boolean hasSSHPublicKey(String publicKey) throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        return this.getSSHKeyByPublicKey(publicKey) != null;
    }

    @Override
    public IOpenShiftSSHKey putSSHKey(String name, ISSHPublicKey key) throws OpenShiftException {
        Assert.notNull(name);
        Assert.notNull(key);
        KeyResourceDTO keyDTO = new AddSShKeyRequest().execute(key.getKeyType(), name, key.getPublicKey());
        return this.put(keyDTO);
    }

    @Override
    public IOpenShiftSSHKey addSSHKey(String name, ISSHPublicKey key) throws OpenShiftException {
        Assert.notNull(name);
        Assert.notNull(key);
        if (this.hasSSHKeyName(name)) {
            throw new OpenShiftSSHKeyException("Could not add new key {0} with the name {1}. There already is a key for this name, key names must be unique.", key.getPublicKey(), name);
        }
        if (this.hasSSHPublicKey(name)) {
            throw new OpenShiftSSHKeyException("Could not add new key {0} with the name {1}. The key is already stored with a different name. Public key have to be unique.", key.getPublicKey(), name);
        }
        KeyResourceDTO keyDTO = new AddSShKeyRequest().execute(key.getKeyType(), name, key.getPublicKey());
        return this.put(keyDTO);
    }

    private SSHKeyResource put(KeyResourceDTO keyDTO) throws OpenShiftUnknonwSSHKeyTypeException {
        SSHKeyResource sshKey = new SSHKeyResource(keyDTO, this);
        this.getCachedOrLoadSSHKeys().put(keyDTO.getName(), sshKey);
        return sshKey;
    }

    protected void removeSSHKey(SSHKeyResource key) {
        this.sshKeys.remove(key.getName());
    }

    public String toString() {
        return "UserResource [rhLogin=" + this.rhLogin + "]";
    }

    private class AddSShKeyRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private AddSShKeyRequest() throws OpenShiftException {
            super(UserResource.this, "ADD_KEY");
        }

        protected KeyResourceDTO execute(SSHKeyType type, String name, String content) throws OpenShiftException {
            return (KeyResourceDTO)super.execute(new StringParameter("type", type.getTypeId()), new StringParameter("name", name), new StringParameter("content", content));
        }
    }

    private class GetSShKeysRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private GetSShKeysRequest() throws OpenShiftException {
            super(UserResource.this, "LIST_KEYS");
        }

        protected List<KeyResourceDTO> execute() throws OpenShiftException {
            return (List)super.execute(new Parameter[0]);
        }
    }
}

