/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.response;

import com.openshift.client.HttpMethod;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftRequestException;
import com.openshift.internal.client.httpclient.EncodingException;
import com.openshift.internal.client.httpclient.request.FormUrlEncodedMediaType;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.ParameterValue;
import com.openshift.internal.client.httpclient.request.ParameterValueMap;
import com.openshift.internal.client.response.LinkParameter;
import com.openshift.internal.client.response.LinkParameterType;
import com.openshift.internal.client.utils.StringUtils;
import com.openshift.internal.client.utils.UrlUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Link {
    private final Pattern PATH_VAR_PATTERN = Pattern.compile(":([a-z_]+)");
    private final String rel;
    private final String href;
    private final HttpMethod httpMethod;
    private final List<LinkParameter> requiredParams;
    private final List<LinkParameter> optionalParams;

    public Link(String href, HttpMethod httpMethod) {
        this(null, href, httpMethod);
    }

    public Link(String rel, String href, HttpMethod httpMethod) {
        this(rel, href, httpMethod, null, null);
    }

    protected Link(String rel, String href, String httpMethod, List<LinkParameter> requiredParams, List<LinkParameter> optionalParams) {
        this(rel, href, HttpMethod.valueOf(httpMethod), requiredParams, optionalParams);
    }

    protected Link(String rel, String href, HttpMethod httpMethod, List<LinkParameter> requiredParams, List<LinkParameter> optionalParams) {
        this.rel = rel;
        this.href = href;
        this.httpMethod = httpMethod;
        this.requiredParams = requiredParams;
        this.optionalParams = optionalParams;
    }

    public final String getRel() {
        return this.rel;
    }

    public final String getHref() {
        return this.href;
    }

    public final String getHref(String server, String servicePath, Parameter ... urlParameters) {
        return this.addParameters(this.ensureAbsoluteUrl(this.href, server, servicePath), urlParameters);
    }

    public final String getHref(String server, String servicePath, List<Parameter> urlPathParameters, List<Parameter> urlParameters) {
        String url = this.substituteUrlPathParameters(this.href, urlPathParameters);
        return this.addParameters(this.ensureAbsoluteUrl(url, server, servicePath), urlParameters);
    }

    public final HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public final List<LinkParameter> getRequiredParams() {
        return this.requiredParams;
    }

    public final List<LinkParameter> getOptionalParams() {
        return this.optionalParams;
    }

    public boolean hasParameter(String name) {
        if (this.getParameter(name, this.requiredParams) != null) {
            return true;
        }
        return this.getParameter(name, this.optionalParams) != null;
    }

    public void validateRequestParameters(Parameter[] parameters) throws OpenShiftRequestException {
        if (this.getRequiredParams() != null) {
            for (LinkParameter requiredParameter : this.getRequiredParams()) {
                this.validateRequiredParameter(requiredParameter, parameters);
            }
        }
        if (this.getOptionalParams() != null) {
            for (LinkParameter optionalParameter : this.getOptionalParams()) {
                this.validateOptionalParameters(optionalParameter);
            }
        }
    }

    private void validateRequiredParameter(LinkParameter linkParameter, Parameter[] parameters) throws OpenShiftRequestException {
        Parameter parameter = this.getParameter(linkParameter.getName(), parameters);
        if (parameter == null) {
            throw new OpenShiftRequestException("Requesting {0}: required request parameter \"{1}\" is missing", this.getHref(), linkParameter.getName());
        }
        if (this.isEmptyString(linkParameter, parameter.getValue())) {
            throw new OpenShiftRequestException("Requesting {0}: required request parameter \"{1}\" is empty", this.getHref(), linkParameter.getName());
        }
    }

    private Parameter getParameter(String name, Parameter[] parameters) {
        if (StringUtils.isEmpty(name) || parameters == null) {
            return null;
        }
        for (Parameter parameter : parameters) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    private LinkParameter getParameter(String name, List<LinkParameter> parameters) {
        if (StringUtils.isEmpty(name) || parameters == null) {
            return null;
        }
        for (LinkParameter parameter : parameters) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    private void validateOptionalParameters(LinkParameter optionalParameter) {
    }

    private boolean isEmptyString(LinkParameter parameter, Object parameterValue) {
        return parameter.getType() == LinkParameterType.STRING && parameterValue instanceof String && StringUtils.isEmpty((String)parameterValue);
    }

    private String ensureAbsoluteUrl(String href, String server, String servicePath) {
        if (StringUtils.isEmpty(href) || href.startsWith("http")) {
            return href;
        }
        if (StringUtils.isEmpty(servicePath) || href.startsWith(servicePath)) {
            return StringUtils.prependIfNonEmpty(server, href);
        }
        if (!href.startsWith(servicePath)) {
            href = UrlUtils.appendPath(servicePath, href);
        }
        return StringUtils.prependIfNonEmpty(server, href);
    }

    private String addParameters(String url, Parameter ... urlParameters) {
        if (urlParameters == null || urlParameters.length == 0) {
            return url;
        }
        return this.addParameters(url, Arrays.asList(urlParameters));
    }

    private String addParameters(String url, List<Parameter> urlParameters) {
        if (urlParameters == null || urlParameters.size() == 0) {
            return url;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(url.getBytes());
            out.write(63);
            new FormUrlEncodedMediaType().writeTo(new ParameterValueMap(urlParameters), out);
            return out.toString();
        }
        catch (IOException e) {
            throw new OpenShiftException(e, "Could not add paramters {0} to url {1}", urlParameters, url);
        }
        catch (EncodingException e) {
            throw new OpenShiftException(e, "Could not add paramters {0} to url {1}", urlParameters, url);
        }
    }

    private String substituteUrlPathParameters(String href, List<Parameter> urlPathParameters) {
        if (urlPathParameters == null || urlPathParameters.size() == 0) {
            return href;
        }
        return this.substituteVariables(href, urlPathParameters);
    }

    private String substituteVariables(String url, List<Parameter> parameters) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        StringBuffer buffer = new StringBuffer();
        Map<String, Parameter> parameterByName = this.toMap(parameters);
        Matcher matcher = this.PATH_VAR_PATTERN.matcher(url);
        while (matcher.find()) {
            Parameter parameter;
            String name = matcher.group(1);
            if (StringUtils.isEmpty(name) || (parameter = parameterByName.get(name)) == null) continue;
            matcher.appendReplacement(buffer, String.valueOf(((ParameterValue)parameter.getValue()).getValue()));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private Map<String, Parameter> toMap(List<Parameter> parameters) {
        HashMap<String, Parameter> parameterByName = new HashMap<String, Parameter>();
        for (Parameter parameter : parameters) {
            parameterByName.put(parameter.getName(), parameter);
        }
        return parameterByName;
    }

    public String toString() {
        return "Link [rel=" + this.rel + ", " + "httpMethod=" + (Object)((Object)this.httpMethod) + ", " + "href=" + this.href + "]";
    }
}

