/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.image;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.Status;
import com.openshift.restclient.IClient;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IStatus;
import com.openshift.restclient.model.image.IImageStreamImport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.jboss.dmr.ModelNode;

public class ImageStreamImport
extends KubernetesResource
implements IImageStreamImport {
    private static final String FROM_KIND = "from.kind";
    public static final String IMAGE_DOCKER_IMAGE_REFERENCE = "image.dockerImageReference";
    private static final String SPEC_IMAGES = "spec.images";
    private static final String SPEC_IMPORT = "spec.import";
    private static final String STATUS = "status";
    public static final String STATUS_IMAGES = "status.images";
    private static final String TAG = "tag";

    public ImageStreamImport(ModelNode node, IClient client, Map<String, String[]> overrideProperties) {
        super(node, client, overrideProperties);
    }

    @Override
    public void setImport(boolean importTags) {
        this.set(SPEC_IMPORT, importTags);
    }

    @Override
    public boolean isImport() {
        return this.asBoolean(SPEC_IMPORT);
    }

    @Override
    public void addImage(String fromKind, DockerImageURI imageUri) {
        ModelNode image = new ModelNode();
        this.set(image, FROM_KIND, fromKind);
        this.set(image, "from.name", imageUri.getAbsoluteUri());
        this.get(SPEC_IMAGES).add(image);
    }

    @Override
    public Collection<IStatus> getImageStatus() {
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        ModelNode images = this.get(STATUS_IMAGES);
        if (images.isDefined()) {
            images.asList().stream().filter(n -> this.get((ModelNode)n, STATUS).isDefined()).forEach(n -> status.add(new Status(this.get((ModelNode)n, STATUS), this.getClient(), this.getPropertyKeys())));
        }
        return status;
    }

    @Override
    public String getImageJsonFor(DockerImageURI uri) {
        Optional<ModelNode> node;
        String prefix = uri.getUriWithoutTag();
        String tag = uri.getTag();
        ModelNode images = this.get(STATUS_IMAGES);
        if (images.isDefined() && (node = images.asList().stream().filter(n -> this.asString((ModelNode)n, IMAGE_DOCKER_IMAGE_REFERENCE).startsWith(prefix) && tag.equals(this.asString((ModelNode)n, TAG))).findFirst()).isPresent()) {
            return node.get().toJSONString(true);
        }
        return null;
    }
}

