/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org;

import com.orgzly.org.OrgPatterns;
import com.orgzly.org.datetime.OrgRange;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public class OrgContent {
    private StringBuilder value = new StringBuilder();
    private List<OrgRange> timestamps;
    private boolean dirty = false;

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public void set(String value) {
        this.value = value == null ? new StringBuilder() : new StringBuilder(value);
        this.dirty = true;
    }

    public void append(String s) {
        this.value.append(s);
        this.dirty = true;
    }

    public String toString() {
        return this.value.toString();
    }

    public List<OrgRange> getTimestamps() {
        if (this.timestamps == null) {
            this.timestamps = new ArrayList<OrgRange>();
        }
        if (this.dirty) {
            this.reparse();
        }
        return this.timestamps;
    }

    public boolean hasTimestamps() {
        if (this.timestamps == null) {
            return false;
        }
        if (this.dirty) {
            this.reparse();
        }
        return !this.timestamps.isEmpty();
    }

    private void reparse() {
        this.timestamps.clear();
        Matcher m = OrgPatterns.DT_OR_RANGE_P.matcher(this.toString());
        while (m.find()) {
            this.timestamps.add(OrgRange.parse(m.group()));
        }
        this.dirty = false;
    }
}

