/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org;

import com.orgzly.org.OrgContent;
import com.orgzly.org.OrgProperties;
import com.orgzly.org.OrgStringUtils;
import com.orgzly.org.datetime.OrgRange;
import java.util.ArrayList;
import java.util.List;

public class OrgHead {
    private String title;
    private List<String> tags;
    private String state;
    private String priority;
    private OrgRange scheduled;
    private OrgRange deadline;
    private OrgRange closed;
    private OrgRange clock;
    private OrgProperties properties;
    private List<String> logbook;
    private OrgContent content;

    public OrgHead() {
        this("");
    }

    public OrgHead(String str) {
        this.title = str;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getTags() {
        if (this.tags == null) {
            return new ArrayList<String>();
        }
        return this.tags;
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public void setTags(String[] tags) {
        if (tags == null) {
            throw new IllegalArgumentException("Tags passed to setTags cannot be null");
        }
        this.tags = new ArrayList<String>();
        for (String tag : tags) {
            if (OrgStringUtils.isEmpty(tag)) continue;
            this.tags.add(tag);
        }
    }

    private OrgContent getContentObject() {
        if (this.content == null) {
            this.content = new OrgContent();
        }
        return this.content;
    }

    public String getContent() {
        return this.getContentObject().toString();
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public void setContent(String s) {
        this.getContentObject().set(s);
    }

    public void appendContent(String s) {
        this.getContentObject().append(s);
    }

    public List<OrgRange> getTimestamps() {
        return this.getContentObject().getTimestamps();
    }

    public boolean hasTimestamps() {
        return this.getContentObject().hasTimestamps();
    }

    public OrgRange getScheduled() {
        if (this.hasScheduled()) {
            return this.scheduled;
        }
        return null;
    }

    public boolean hasScheduled() {
        return this.scheduled != null && this.scheduled.isSet();
    }

    public void setScheduled(OrgRange time) {
        this.scheduled = time;
    }

    public OrgRange getClosed() {
        if (this.hasClosed()) {
            return this.closed;
        }
        return null;
    }

    public boolean hasClosed() {
        return this.closed != null && this.closed.isSet();
    }

    public void setClosed(OrgRange time) {
        this.closed = time;
    }

    public OrgRange getDeadline() {
        if (this.hasDeadline()) {
            return this.deadline;
        }
        return null;
    }

    public boolean hasDeadline() {
        return this.deadline != null && this.deadline.isSet();
    }

    public void setDeadline(OrgRange time) {
        this.deadline = time;
    }

    public OrgRange getClock() {
        if (this.hasClock()) {
            return this.clock;
        }
        return null;
    }

    public boolean hasClock() {
        return this.clock != null && this.clock.isSet();
    }

    public void setClock(OrgRange time) {
        this.clock = time;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public OrgProperties getProperties() {
        if (this.properties == null) {
            this.properties = new OrgProperties();
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new OrgProperties();
        }
        this.properties.put(name, value);
    }

    public void setProperties(OrgProperties properties) {
        this.properties = properties;
    }

    public void removeProperties() {
        this.properties = null;
    }

    public void initLogbook() {
        if (this.logbook == null) {
            this.logbook = new ArrayList<String>();
        }
    }

    public List<String> getLogbook() {
        if (this.logbook == null) {
            throw new IllegalArgumentException("Logbook does not exist");
        }
        return this.logbook;
    }

    public boolean hasLogbook() {
        return this.logbook != null;
    }

    public void addLog(String log) {
        this.initLogbook();
        this.logbook.add(log);
    }

    public String toString() {
        return this.title;
    }
}

