/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.datetime;

import com.orgzly.org.OrgPatterns;
import com.orgzly.org.OrgStringUtils;
import com.orgzly.org.datetime.OrgDelay;
import com.orgzly.org.datetime.OrgRepeater;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OrgDateTime {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd EEE", Locale.ENGLISH);
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm", Locale.ENGLISH);
    private boolean isActive;
    private String string;
    private String stringWithoutBrackets;
    private Calendar cal;
    private boolean hasTime;
    private Calendar endCal;
    private OrgRepeater repeater;
    private OrgDelay delay;

    private OrgDateTime() {
    }

    public OrgDateTime(boolean isActive) {
        this.isActive = isActive;
        this.cal = GregorianCalendar.getInstance();
        this.cal.set(13, 0);
        this.cal.set(14, 0);
        this.hasTime = true;
    }

    public OrgDateTime(long millis, boolean isActive) {
        this.isActive = isActive;
        this.cal = GregorianCalendar.getInstance();
        this.cal.setTimeInMillis(millis);
        this.cal.set(13, 0);
        this.cal.set(14, 0);
        this.hasTime = true;
    }

    public static OrgDateTime parse(String str) {
        if (str == null) {
            throw new IllegalArgumentException("OrgDateTime cannot be created from null string");
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException("OrgDateTime cannot be created from null string");
        }
        OrgDateTime time = new OrgDateTime();
        time.string = str;
        return time;
    }

    public static OrgDateTime parseOrNull(String str) {
        if (OrgStringUtils.isEmpty(str)) {
            return null;
        }
        OrgDateTime time = new OrgDateTime();
        time.string = str;
        return time;
    }

    public static OrgDateTime doParse(String str) {
        try {
            OrgDateTime time = OrgDateTime.parse(str);
            time.ensureCalendar();
            return time;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Calendar getCalendar() {
        this.ensureCalendar();
        return this.cal;
    }

    public boolean isActive() {
        this.ensureCalendar();
        return this.isActive;
    }

    public boolean hasTime() {
        this.ensureCalendar();
        return this.hasTime;
    }

    public boolean hasEndTime() {
        this.ensureCalendar();
        return this.endCal != null;
    }

    public Calendar getEndCalendar() {
        this.ensureCalendar();
        return this.endCal;
    }

    public boolean hasRepeater() {
        this.ensureCalendar();
        return this.repeater != null;
    }

    public OrgRepeater getRepeater() {
        this.ensureCalendar();
        return this.repeater;
    }

    public boolean hasDelay() {
        this.ensureCalendar();
        return this.delay != null;
    }

    public OrgDelay getDelay() {
        this.ensureCalendar();
        return this.delay;
    }

    private String fromCalendar(boolean withBrackets) {
        StringBuilder result = new StringBuilder();
        if (withBrackets) {
            result.append(this.isActive() ? (char)'<' : '[');
        }
        result.append(DATE_FORMAT.format(this.cal.getTime()));
        if (this.hasTime) {
            result.append(" ");
            result.append(TIME_FORMAT.format(this.cal.getTime()));
            if (this.endCal != null) {
                result.append("-");
                result.append(TIME_FORMAT.format(this.endCal.getTime()));
            }
        }
        if (this.hasRepeater()) {
            result.append(" ");
            result.append(this.repeater);
        }
        if (this.hasDelay()) {
            result.append(" ");
            result.append(this.delay);
        }
        if (withBrackets) {
            result.append(this.isActive() ? (char)'>' : ']');
        }
        return result.toString();
    }

    private void ensureCalendar() {
        if (this.cal == null) {
            if (this.string == null) {
                throw new IllegalStateException("Missing string");
            }
            this.parseString();
        }
    }

    private void parseString() {
        this.cal = Calendar.getInstance();
        this.endCal = null;
        switch (this.string.charAt(0)) {
            case '<': {
                this.isActive = true;
                break;
            }
            case '[': {
                this.isActive = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Timestamp \"" + this.string + "\" must start with < or [");
            }
        }
        Matcher m = OrgPatterns.DT_MAYBE_WITH_TIME_P.matcher(this.string);
        if (!m.find()) {
            this.matchFailed(this.string, OrgPatterns.DT_MAYBE_WITH_TIME_P);
        }
        this.cal.set(1, Integer.valueOf(m.group(2)));
        this.cal.set(2, Integer.valueOf(m.group(3)) - 1);
        this.cal.set(5, Integer.valueOf(m.group(4)));
        if (!OrgStringUtils.isEmpty(m.group(6))) {
            this.parseTimeOfDay(this.string.substring(m.start(6)));
        } else {
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.hasTime = false;
        }
        this.cal.set(13, 0);
        this.cal.set(14, 0);
        m = OrgPatterns.REPEAT_P.matcher(this.string);
        if (m.find()) {
            this.repeater = OrgRepeater.parse(m.group(1));
        }
        if ((m = OrgPatterns.TIME_DELAY_P.matcher(this.string)).find()) {
            this.delay = OrgDelay.parse(m.group(0));
        }
    }

    private void parseTimeOfDay(String str) {
        Matcher m = OrgPatterns.TIME_OF_DAY_P.matcher(str);
        if (!m.find()) {
            this.matchFailed(str, OrgPatterns.TIME_OF_DAY_P);
        }
        this.cal.set(11, Integer.valueOf(m.group(2)));
        this.cal.set(12, Integer.valueOf(m.group(3)));
        this.hasTime = true;
        if (!OrgStringUtils.isEmpty(m.group(4))) {
            this.endCal = Calendar.getInstance();
            this.endCal.setTime(this.cal.getTime());
            this.endCal.set(11, Integer.valueOf(m.group(6)));
            this.endCal.set(12, Integer.valueOf(m.group(7)));
            this.endCal.set(13, 0);
            this.endCal.set(14, 0);
        }
    }

    private void matchFailed(String string, Pattern pattern) {
        throw new IllegalArgumentException("Failed matching \"" + string + "\" against " + pattern);
    }

    public boolean shift(Calendar now) {
        if (this.hasRepeater()) {
            this.cal = this.getCalendar();
            this.endCal = this.getEndCalendar();
            this.repeater.shiftCalendar(this.cal, now);
            if (this.endCal != null) {
                this.repeater.shiftCalendar(this.endCal, now);
            }
            this.string = null;
            this.stringWithoutBrackets = null;
        }
        return this.repeater != null;
    }

    public String toString() {
        if (this.string == null && this.cal != null) {
            this.string = this.fromCalendar(true);
        }
        return this.string;
    }

    public String toStringWithoutBrackets() {
        this.ensureCalendar();
        if (this.stringWithoutBrackets == null && this.cal != null) {
            this.stringWithoutBrackets = this.fromCalendar(false);
        }
        return this.stringWithoutBrackets;
    }

    public static class Builder {
        private boolean isActive;
        private boolean hasTime;
        private boolean hasRepeater;
        private int year;
        private int month;
        private int day;
        private int hour;
        private int minute;
        private OrgRepeater repeater;

        public Builder setIsActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public Builder setHasTime(boolean isTimeUsed) {
            this.hasTime = isTimeUsed;
            return this;
        }

        public Builder setHasRepeater(boolean isRepeaterUsed) {
            this.hasRepeater = isRepeaterUsed;
            return this;
        }

        public Builder setYear(int year) {
            this.year = year;
            return this;
        }

        public Builder setMonth(int month) {
            this.month = month;
            return this;
        }

        public Builder setDay(int day) {
            this.day = day;
            return this;
        }

        public Builder setHour(int hour) {
            this.hour = hour;
            return this;
        }

        public Builder setMinute(int minute) {
            this.minute = minute;
            return this;
        }

        public Builder setRepeater(OrgRepeater repeater) {
            this.repeater = repeater;
            return this;
        }

        public OrgDateTime build() {
            OrgDateTime time = new OrgDateTime();
            time.isActive = this.isActive;
            time.hasTime = this.hasTime;
            time.cal = new GregorianCalendar(this.year, this.month, this.day, this.hour, this.minute);
            if (this.hasRepeater) {
                time.repeater = this.repeater;
            }
            return time;
        }
    }
}

