/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.datetime;

import com.orgzly.org.OrgPatterns;
import com.orgzly.org.datetime.OrgInterval;
import java.util.regex.Matcher;

public class OrgDelay
extends OrgInterval {
    private Type type;

    public static OrgDelay parse(String str) {
        OrgDelay delay = new OrgDelay();
        Matcher m = OrgPatterns.TIME_DELAY_P.matcher(str);
        if (m.find()) {
            if (m.groupCount() != 3) {
                throw new IllegalArgumentException("Expected 3 groups (got " + m.groupCount() + ") when matching time delay " + str + " against " + OrgPatterns.TIME_DELAY_P);
            }
        } else {
            throw new IllegalArgumentException("Failed matching time delay " + str + " against " + OrgPatterns.TIME_DELAY_P);
        }
        delay.setTypeFromString(m.group(1));
        delay.setValue(m.group(2));
        delay.setUnit(m.group(3));
        return delay;
    }

    private void setTypeFromString(String str) {
        if ("-".equals(str)) {
            this.type = Type.ALL;
        } else if ("--".equals(str)) {
            this.type = Type.FIRST_ONLY;
        } else {
            throw new IllegalArgumentException("Unknown time delay type " + str);
        }
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        switch (this.type) {
            case ALL: {
                return "-" + super.toString();
            }
            case FIRST_ONLY: {
                return "--" + super.toString();
            }
        }
        throw new IllegalArgumentException("Unknown time delay type " + (Object)((Object)this.type));
    }

    public static enum Type {
        ALL,
        FIRST_ONLY;

    }
}

