/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.datetime;

public class OrgInterval {
    protected int value;
    protected Unit unit;

    protected OrgInterval() {
    }

    public OrgInterval(String value, String unit) {
        this.setValue(value);
        this.setUnit(unit);
    }

    public OrgInterval(int value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(String str) {
        try {
            this.value = Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Interval value " + str + " couldn't be parsed as integer", e);
        }
    }

    public void setValue(int val) {
        this.value = val;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(String str) {
        if ("h".equals(str)) {
            this.unit = Unit.HOUR;
        } else if ("d".equals(str)) {
            this.unit = Unit.DAY;
        } else if ("w".equals(str)) {
            this.unit = Unit.WEEK;
        } else if ("m".equals(str)) {
            this.unit = Unit.MONTH;
        } else if ("y".equals(str)) {
            this.unit = Unit.YEAR;
        } else {
            throw new IllegalArgumentException("Unknown unit " + str);
        }
    }

    public void setUnit(Unit u) {
        this.unit = u;
    }

    public String toString() {
        switch (this.unit) {
            case HOUR: {
                return this.value + "h";
            }
            case DAY: {
                return this.value + "d";
            }
            case WEEK: {
                return this.value + "w";
            }
            case MONTH: {
                return this.value + "m";
            }
            case YEAR: {
                return this.value + "y";
            }
        }
        throw new IllegalArgumentException("Unknown unit " + (Object)((Object)this.unit));
    }

    public static enum Unit {
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

