/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.datetime;

import com.orgzly.org.OrgPatterns;
import com.orgzly.org.OrgStringUtils;
import com.orgzly.org.datetime.OrgInterval;
import java.util.Calendar;
import java.util.regex.Matcher;

public class OrgRepeater
extends OrgInterval {
    private Type type;
    private OrgInterval habitDeadline;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OrgRepeater parse(String str) {
        OrgRepeater repeater = new OrgRepeater();
        Matcher m = OrgPatterns.REPEATER.matcher(str);
        if (!m.find()) throw new IllegalArgumentException("Failed matching repeater " + str + " against " + OrgPatterns.REPEATER);
        if (m.groupCount() != 7) throw new IllegalArgumentException("Expected 7 groups (got " + m.groupCount() + ") when matching repeater " + str + " against " + OrgPatterns.REPEATER);
        repeater.setTypeFromString(m.group(2));
        repeater.setValue(m.group(3));
        repeater.setUnit(m.group(4));
        if (OrgStringUtils.isEmpty(m.group(6))) return repeater;
        repeater.habitDeadline = new OrgInterval();
        repeater.habitDeadline.setValue(m.group(6));
        repeater.habitDeadline.setUnit(m.group(7));
        return repeater;
    }

    private OrgRepeater() {
    }

    public OrgRepeater(Type type, int value, OrgInterval.Unit unit) {
        this.type = type;
        this.value = value;
        this.unit = unit;
    }

    private void setTypeFromString(String str) {
        if ("+".equals(str)) {
            this.type = Type.CUMULATE;
        } else if ("++".equals(str)) {
            this.type = Type.CATCH_UP;
        } else if (".+".equals(str)) {
            this.type = Type.RESTART;
        } else {
            throw new IllegalArgumentException("Unknown repeater type " + str);
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasHabitDeadline() {
        return this.habitDeadline != null;
    }

    public OrgInterval getHabitDeadline() {
        return this.habitDeadline;
    }

    public void shiftCalendar(Calendar cal, Calendar now) {
        switch (this.type) {
            case CUMULATE: {
                this.shiftByInterval(cal);
                break;
            }
            case CATCH_UP: {
                do {
                    this.shiftByInterval(cal);
                } while (!cal.after(now));
                break;
            }
            case RESTART: {
                cal.set(1, now.get(1));
                cal.set(2, now.get(2));
                cal.set(5, now.get(5));
                if (this.getUnit() == OrgInterval.Unit.HOUR) {
                    cal.set(11, now.get(11));
                }
                this.shiftByInterval(cal);
            }
        }
    }

    private void shiftByInterval(Calendar cal) {
        switch (this.getUnit()) {
            case HOUR: {
                cal.add(11, this.getValue());
                break;
            }
            case DAY: {
                cal.add(5, this.getValue());
                break;
            }
            case WEEK: {
                cal.add(3, this.getValue());
                break;
            }
            case MONTH: {
                cal.add(2, this.getValue());
                break;
            }
            case YEAR: {
                cal.add(1, this.getValue());
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        switch (this.type) {
            case CUMULATE: {
                s.append("+");
                break;
            }
            case CATCH_UP: {
                s.append("++");
                break;
            }
            case RESTART: {
                s.append(".+");
            }
        }
        s.append(super.toString());
        return s.toString();
    }

    public static enum Type {
        CUMULATE,
        CATCH_UP,
        RESTART;

    }
}

