/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.parser;

import com.orgzly.org.OrgFile;
import com.orgzly.org.OrgHead;
import com.orgzly.org.parser.OrgNestedSetParserListener;
import com.orgzly.org.parser.OrgNodeInList;
import com.orgzly.org.parser.OrgNodeInSet;
import com.orgzly.org.parser.OrgParsedFile;
import com.orgzly.org.parser.OrgParser;
import com.orgzly.org.parser.OrgParserSettings;
import com.orgzly.org.parser.OrgSaxyParserListener;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;

public class OrgNestedSetParser
extends OrgParser {
    public static final int STARTING_LEVEL = 0;
    public static final long STARTING_VALUE = 1L;
    private static final int GAP = 5;
    private Reader reader;
    private OrgNestedSetParserListener listener;

    public OrgNestedSetParser(OrgParserSettings settings, Reader reader, OrgNestedSetParserListener listener) {
        this.settings = settings;
        this.reader = reader;
        this.listener = listener;
    }

    @Override
    public OrgParsedFile parse() throws IOException {
        final Stack<OrgNodeInSet> stack = new Stack<OrgNodeInSet>();
        stack.push(new OrgNodeInSet(0, 1L, new OrgHead()));
        OrgParser.Builder builder = new OrgParser.Builder(this.settings).setInput(this.reader).setListener(new OrgSaxyParserListener(){
            int prevLevel = 0;
            long sequence = 1L;

            @Override
            public void onHead(OrgNodeInList thisNode) throws IOException {
                if (this.prevLevel < thisNode.getLevel()) {
                    this.sequence += 5L;
                    stack.push(new OrgNodeInSet(thisNode.getLevel(), this.sequence, thisNode.getHead()));
                } else if (this.prevLevel == thisNode.getLevel()) {
                    OrgNodeInSet nodeFromStack = (OrgNodeInSet)stack.pop();
                    this.sequence += 5L;
                    nodeFromStack.setRgt(this.sequence);
                    OrgNestedSetParser.this.calculateAndSetDescendantsCount(nodeFromStack, 5);
                    OrgNestedSetParser.this.listener.onNode(nodeFromStack);
                    this.sequence += 5L;
                    stack.push(new OrgNodeInSet(thisNode.getLevel(), this.sequence, thisNode.getHead()));
                } else {
                    OrgNodeInSet nodeFromStack;
                    while (!stack.empty() && (nodeFromStack = (OrgNodeInSet)stack.peek()).getLevel() >= thisNode.getLevel()) {
                        stack.pop();
                        this.sequence += 5L;
                        nodeFromStack.setRgt(this.sequence);
                        OrgNestedSetParser.this.calculateAndSetDescendantsCount(nodeFromStack, 5);
                        OrgNestedSetParser.this.listener.onNode(nodeFromStack);
                    }
                    this.sequence += 5L;
                    stack.push(new OrgNodeInSet(thisNode.getLevel(), this.sequence, thisNode.getHead()));
                }
                this.prevLevel = thisNode.getLevel();
            }

            @Override
            public void onFile(OrgFile file) throws IOException {
                while (!stack.empty()) {
                    OrgNodeInSet nodeFromStack = (OrgNodeInSet)stack.pop();
                    this.sequence += 5L;
                    nodeFromStack.setRgt(this.sequence);
                    OrgNestedSetParser.this.calculateAndSetDescendantsCount(nodeFromStack, 5);
                    OrgNestedSetParser.this.listener.onNode(nodeFromStack);
                }
                OrgNestedSetParser.this.listener.onFile(file);
            }
        });
        builder.build().parse();
        return null;
    }

    private void calculateAndSetDescendantsCount(OrgNodeInSet node, int gap) {
        int n = (int)(node.getRgt() - node.getLft() - (long)gap) / (2 * gap);
        node.setDescendantsCount(n);
    }
}

