/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.parser;

import com.orgzly.org.parser.OrgDomyParser;
import com.orgzly.org.parser.OrgNestedSetParser;
import com.orgzly.org.parser.OrgNestedSetParserListener;
import com.orgzly.org.parser.OrgParsedFile;
import com.orgzly.org.parser.OrgParserSettings;
import com.orgzly.org.parser.OrgSaxyParser;
import com.orgzly.org.parser.OrgSaxyParserListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class OrgParser {
    protected OrgParserSettings settings;

    public abstract OrgParsedFile parse() throws IOException;

    public static class Builder {
        private OrgParserSettings settings;
        private Reader reader;
        private OrgSaxyParserListener listener;
        private OrgNestedSetParserListener nestedSetListener;

        public Builder() {
            this.settings = new OrgParserSettings();
        }

        public Builder(OrgParserSettings settings) {
            this.settings = new OrgParserSettings(settings);
        }

        public Builder setTodoKeywords(String[] keywords) {
            this.settings.todoKeywords = new HashSet<String>(Arrays.asList(keywords));
            return this;
        }

        public Builder setTodoKeywords(Set<String> keywords) {
            this.settings.todoKeywords = keywords;
            return this;
        }

        public Builder setDoneKeywords(String[] keywords) {
            this.settings.doneKeywords = new HashSet<String>(Arrays.asList(keywords));
            return this;
        }

        public Builder setDoneKeywords(Set<String> keywords) {
            this.settings.doneKeywords = keywords;
            return this;
        }

        public Builder setListener(OrgSaxyParserListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder setListener(OrgNestedSetParserListener listener) {
            this.nestedSetListener = listener;
            return this;
        }

        public Builder setInput(Reader reader) {
            this.reader = reader;
            return this;
        }

        public Builder setInput(String data) {
            this.reader = new StringReader(data);
            return this;
        }

        public OrgParser build() {
            if (this.reader == null) {
                throw new IllegalStateException("Reader not set. Use setInput() before building the parser.");
            }
            if (this.listener != null) {
                return new OrgSaxyParser(this.settings, this.reader, this.listener);
            }
            if (this.nestedSetListener != null) {
                return new OrgNestedSetParser(this.settings, this.reader, this.nestedSetListener);
            }
            return new OrgDomyParser(this.settings, this.reader);
        }
    }
}

