/* Copyright (c) 2007-2014 by panayotis.com
 *
 * JavaPlot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * JavaPlot is free in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with CrossMobile; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Created on October 24, 2007, 7:53 PM
 */
package com.panayotis.gnuplot.swing;

import com.panayotis.gnuplot.JavaPlot;
import com.panayotis.gnuplot.terminal.ImageTerminal;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

/**
 * This Object uses an ImageTerminal as a backend, in order to draw the selected
 * plot
 *
 * @author teras
 */
public class JPlot extends JPanel {

    private JavaPlot plot;
    private ImageTerminal term;

    /**
     * Creates new form JPlot with a blank JavaPlot
     */
    public JPlot() {
        this(new JavaPlot());
    }

    /**
     * Create a new form JPlot with a specified JavaPlot
     *
     * @param plot the JavaPlot to use
     */
    public JPlot(JavaPlot plot) {
        initComponents();
        term = new ImageTerminal();
        setJavaPlot(plot);
    }

    /**
     * Change the current JavaPlot
     *
     * @param javaplot the JavaPlot to use
     */
    public final void setJavaPlot(JavaPlot javaplot) {
        plot = javaplot;
        plot.setTerminal(term);
    }

    /**
     * Retrieve the JavaPlot of this JPlot.
     *
     * @return the JavaPlot being used
     */
    public JavaPlot getJavaPlot() {
        return plot;
    }

    /**
     * Perform a plot on this object
     */
    public void plot() {
        if (plot == null)
            return;
        plot.plot();
        BufferedImage img = term.getImage();
        setPreferredSize(new Dimension(img.getWidth(), img.getHeight()));
    }

    /**
     * Paint this component
     *
     * @param g Graphics handler for this component
     */
    @Override
    public void paint(Graphics g) {
        BufferedImage img = term.getImage();
        if (img == null)
            return;
        g.drawImage(img, 0, 0, null);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
