/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot;

import com.panayotis.gnuplot.GNUPlot;
import com.panayotis.gnuplot.GNUPlotException;
import com.panayotis.gnuplot.GNUPlotParameters;
import com.panayotis.gnuplot.terminal.GNUPlotTerminal;
import com.panayotis.gnuplot.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

class GNUPlotExec {
    private static final transient String DEFAULT_PATH = FileUtils.findPathExec();
    private transient String gnuplotexec;
    private boolean ispersist;
    private static final String[] persistcommand = new String[]{"path", "file", "-persist"};
    private static final String[] nopersist = new String[]{"path", "file"};

    GNUPlotExec() throws IOException {
        this(null);
    }

    GNUPlotExec(String path) throws IOException {
        if (path == null) {
            path = DEFAULT_PATH;
        }
        this.setGNUPlotPath(path);
        this.ispersist = true;
    }

    final void setGNUPlotPath(String path) throws IOException {
        if (!new File(path).isFile()) {
            throw new IOException("GnuPlot executable \"" + path + "\" not found.");
        }
        this.gnuplotexec = path;
    }

    String getGNUPlotPath() {
        return this.gnuplotexec;
    }

    public String getCommands(GNUPlotParameters par, GNUPlotTerminal terminal) {
        return par.getPlotCommands(terminal);
    }

    void plot(GNUPlotParameters par, GNUPlotTerminal terminal) throws GNUPlotException {
        try {
            final GNUPlotTerminal term = terminal;
            String comms = this.getCommands(par, term);
            final Messages msg = new Messages();
            GNUPlot.getDebugger().msg("** Start of plot commands **", 40);
            GNUPlot.getDebugger().msg(comms, 40);
            GNUPlot.getDebugger().msg("** End of plot commands **", 40);
            String[] command = this.ispersist ? persistcommand : nopersist;
            command[0] = this.getGNUPlotPath();
            command[1] = FileUtils.createTempFile(comms);
            String cmdStr = "";
            for (String cmd : command) {
                cmdStr = cmdStr + cmd + " ";
            }
            GNUPlot.getDebugger().msg("exec(" + cmdStr + ")", 40);
            final Process proc = Runtime.getRuntime().exec(command);
            Thread err_thread = new Thread(){

                public void run() {
                    BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    StringBuilder buf = new StringBuilder();
                    try {
                        String line;
                        while ((line = err.readLine()) != null) {
                            if (line.trim().equals("")) continue;
                            buf.append(line).append('\n');
                        }
                        err.close();
                        msg.output = buf.toString();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(new PrintStream(System.out));
                    }
                }
            };
            err_thread.start();
            Thread out_thread = new Thread(){

                public void run() {
                    msg.process = term.processOutput(proc.getInputStream());
                }
            };
            out_thread.start();
            try {
                proc.waitFor();
                out_thread.join();
                err_thread.join();
            }
            catch (InterruptedException ex) {
                throw new GNUPlotException("Interrupted execution of gnuplot");
            }
            new File(command[1]).delete();
            String message = msg.error != null ? msg.error : msg.process;
            int level = 50;
            if (message != null) {
                level = 20;
            }
            GNUPlot.getDebugger().msg("** Start of error stream **", level);
            GNUPlot.getDebugger().msg(msg.output, level);
            GNUPlot.getDebugger().msg("** End of error stream **", level);
            if (message != null) {
                throw new GNUPlotException(message);
            }
        }
        catch (IOException ex) {
            throw new GNUPlotException("IOException while executing \"" + this.getGNUPlotPath() + "\":" + ex.getLocalizedMessage());
        }
    }

    void setPersist(boolean persist) {
        this.ispersist = persist;
    }

    private class Messages {
        String output = "";
        String error = null;
        String process = null;

        private Messages() {
        }
    }
}

